#!/bin/bash

set -e
source ./icat_server.conf

# Add facility
entities='[{"Facility":{"name":"CSNS","fullName":"China Spallation Neutron Source","url":"http://csns.ihep.ac.cn", "daysUntilRelease":730}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

#resp=$($curl ''$url'/icat/entityManager?sessionId='$sessionId'&query=SELECT%20f.id%20FROM%20Facility%20f%20WHERE%20f.name%3D'\''CSNS'\''')
resp=$($curl "$url/icat/entityManager?sessionId=$sessionId&query=SELECT%20f.id%20FROM%20Facility%20f%20WHERE%20f.name%3D'CSNS'")
csnsId=$(echo $resp | python -c "import sys, json; print json.load(sys.stdin)[0]")
# Add instrument
entities='[{"Instrument":{"name":"BL01","fullName":"Small-Angle Neutron Scattering Diffractometer","facility":{"id":'$csnsId'}}},'\
'{"Instrument":{"name":"BL02","fullName":"Multi-purpose Reflectometer","facility":{"id":'$csnsId'}}},'\
'{"Instrument":{"name":"BL18","fullName":"General Purpose Powder Diffractometer","facility":{"id":'$csnsId'}}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add User (Instrument scientist)
entities='[{"User":{"name":"ldap/helh","fullName":"He Lunhua"}},
{"User":{"name":"ldap/taojz","fullName":"Tao Juzhou"}},
{"User":{"name":"ldap/zhut","fullName":"Zhu Tao"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add InstrumentScientist
entities='[{"InstrumentScientist":{"instrument":{"id":1},"user":{"id":9}}},
{"InstrumentScientist":{"instrument":{"id":2},"user":{"id":10}}},
{"InstrumentScientist":{"instrument":{"id":3},"user":{"id":8}}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add FacilityCycle
#entities='[{"FacilityCycle":{"facility":{"id":4},"name":"2018 Spring", "startDate":"2018-01-01T00:00:00.000-20:00","endDate":"2018-03-25T17:00:00.000-20:00"}},
#{"FacilityCycle":{"facility":{"id":4},"name":"2018 Autumn", "startDate":"2018-06-01T08:00:00.000-20:00","endDate":"2018-09-29T24:00:00.000-20:00"}}]'
entities='[{"FacilityCycle":{"facility":{"id":'$csnsId'},"name":"2018-01"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add DatafileFormat
entities='[{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"raw_monitor","type":"binary","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"nexus","type":"hdf5","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"nexus_monitor","type":"hdf5","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"raw_detector","type":"binary","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"raw_detector_pulse","type":"binary","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"proton_current","type":"ascii","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"control_summary","type":"xml","version":"1.0"}},'\
'{"DatafileFormat":{"facility":{"id":'$csnsId'},"name":"detector_summary","type":"xml","version":"1.0"}}]'
$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add Application
entities='[{"Application":{"facility":{"id":4},"name":"mantid","version":"3.8"}},
{"Application":{"facility":{"id":4},"name":"cockpit","version":"1.0"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add DatasetType
entities='[{"DatasetType":{"facility":{"id":'$csnsId'},"name":"reconstructed"}},'\
'{"DatasetType":{"facility":{"id":'$csnsId'},"name":"reduced"}},'\
'{"DatasetType":{"facility":{"id":'$csnsId'},"name":"analyzed"}},'\
'{"DatasetType":{"facility":{"id":'$csnsId'},"name":"raw"}}]'
#entities='[{"DatasetType":{"facility":{"id":'$csnsId'},"name":"raw"}}]'
#resp=$($curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities")
#commissioningId=$(echo $resp | python -c "import sys, json; print json.load(sys.stdin)[0]")
#echo $commissioningId

# Add InvestigstionType
entities='[{"InvestigationType":{"facility":{"id":4},"name":"common"}},
{"InvestigationType":{"facility":{"id":4},"name":"critical"}},
{"InvestigationType":{"facility":{"id":4},"name":"commercial"}}]'
entities='[{"InvestigationType":{"facility":{"id":'$csnsId'},"name":"commissioning"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add ParameterType
#entities='[{"ParameterType":{"facility":{"id":4},"applicableToDataCollection":true,"applicableToDatafile":true,"applicableToDataset":true,"applicableToInvestigation":true, "applicableToSample":true,"name":"mass","units":"gram","valueType":"NUMERIC"}},
#{"ParameterType":{"facility":{"id":4},"applicableToDataCollection":true,"applicableToDatafile":true,"applicableToDataset":true,"applicableToInvestigation":true, "applicableToSample":true,"name":"date","units":"","valueType":"DATE_AND_TIME"}},
#{"ParameterType":{"facility":{"id":4},"applicableToDataCollection":true,"applicableToDatafile":true,"applicableToDataset":true,"applicableToInvestigation":true, "applicableToSample":true,"name":"comment","units":"","valueType":"STRING"}}]'
entities='[{"ParameterType":{"facility":{"id":'$csnsId'},"applicableToDataCollection":false,"applicableToDatafile":false,"applicableToDataset":true,"applicableToInvestigation":false, "applicableToSample":true,"name":"Run","units":"","valueType":"STRING"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add SampleType
entities='[{"SampleType":{"facility":{"id":4},"molecularFormula":"H2O","name":"water","safetyInformation":"safe"}},
{"SampleType":{"facility":{"id":4},"molecularFormula":"Si","name":"silicon","safetyInformation":"safe"}},
{"SampleType":{"facility":{"id":4},"molecularFormula":"Ni","name":"nickel","safetyInformation":"safe"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

####################################
# Add Investigation
entities='[{"Investigation":{"facility":{"id":4},"type":{"id":1},"name":"silicon calibration","startDate":"2018-07-05T12:38:29.003-20:00","endDate":"2018-07-06T02:07:23.050-20:00", "releaseDate":"2020-07-05T12:38:29.003-20:00","summary":"first calibration","title":"Silicon standard sample","visitId":"tangm"}},
{"Investigation":{"facility":{"id":4},"type":{"id":1},"name":"water calibration","startDate":"2018-07-15T12:00:00.004-20:00","endDate":"2018-07-20T12:00:00.000-20:00", "releaseDate":"2020-07-15T12:00:00.004-20:00","summary":"second calibration","title":"Water standard sample","visitId":"tangm"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add InvestigtionUser
entities='[{"InvestigationUser":{"investigation":{"id":2},"user":{"id":4},"role":"primary"}},
{"InvestigationUser":{"investigation":{"id":3},"user":{"id":4},"role":"primary"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add InvestigationInstrument
entities='[{"InvestigationInstrument":{"investigation":{"id":2},"instrument":{"id":3}}},
{"InvestigationInstrument":{"investigation":{"id":3},"instrument":{"id":2}}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add Sample
entities='[{"Sample":{"type":{"id":4},"investigation":{"id":2},"name":"silicon #1"}},
{"Sample":{"type":{"id":3},"investigation":{"id":3},"name":"water #1"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add Dataset
entities='[{"Dataset":{"investigation":{"id":2},"sample":{"id":1},"type":{"id":1},"complete":true,"location":"/csns/TS1/BL18/RUN0000001","name":"scatterring","startDate":"2018-07-05T13:00:00.003-20:00","endDate":"2018-07-05T16:38:29.003-20:00","description":"Sample scatterring"}},
{"Dataset":{"investigation":{"id":3},"sample":{"id":2},"type":{"id":1},"complete":true,"location":"/csns/TS1/BL02/RUN0000001","name":"scatterring","startDate":"2018-07-15T13:00:00.003-20:00","endDate":"2018-07-16T16:38:29.003-20:00","description":"Sample scatterring"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add DatasetParameter
entities='[{"DatasetParameter":{"dataset":{"id":1},"type":{"id":1},"stringValue":"RUN0000234"}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add Datafile
entities='[{"Datafile":{"dataset":{"id":1},"datafileFormat":{"id":3},"checksum":"ea8edf460acef87d3b5","datafileCreateTime":"2018-07-05T13:10:00.003-20:00","description":"DAQ raw data","fileSize":535780045,"location":"/csns/TS1/BL18/RUN0000001/daq-001.dat","name":"daq-001-raw"}},
{"Datafile":{"dataset":{"id":1},"datafileFormat":{"id":1},"checksum":"aa78ebb4a0acefafdd3f","datafileCreateTime":"2018-07-05T13:30:00.003-20:00","description":"run summary","fileSize":42908,"location":"/csns/TS1/BL18/RUN0000001/run-summary.xml","name":"run-summary"}},
{"Datafile":{"dataset":{"id":1},"datafileFormat":{"id":2},"checksum":"53eaf8ad92df732faccd","datafileCreateTime":"2018-07-05T14:30:00.003-20:00","description":"reconstructed nexus","fileSize":99834772,"location":"/csns/TS1/BL18/RUN0000001/run0000001.nexus","name":"reconstructed-nexus"}},
{"Datafile":{"dataset":{"id":2},"datafileFormat":{"id":3},"checksum":"e8fe92293991dc12dca8","datafileCreateTime":"2018-07-15T13:00:00.003-20:00","description":"DAQ raw data","fileSize":239844166,"location":"/csns/TS1/BL02/RUN0000001/daq-001.dat","name":"daq-001-raw"}},
{"Datafile":{"dataset":{"id":2},"datafileFormat":{"id":1},"checksum":"9d46a35c7d82ffe7a5cc","datafileCreateTime":"2018-07-15T13:05:00.003-20:00","description":"run summary","fileSize":33504,"location":"/csns/TS1/BL02/RUN0000001/run-summary.xml","name":"run-summary"}}
]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"

# Add DatafileParameter
entities='[{"DatafileParameter":{"datafile":{"id":1},"type":{"id":3},"stringValue":"Good data"}},
{"DatafileParameter":{"datafile":{"id":2},"type":{"id":2},"dateTimeValue":"2018-07-06T22:30:00.003-20:00"}},
{"DatafileParameter":{"datafile":{"id":3},"type":{"id":3},"numericValue":0.2}}]'
#$curl --request POST --url "$url/icat/entityManager" --data 'sessionId='"$sessionId"'&entities='"$entities"
