#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import time
import glob
import subprocess
import shlex

from config import config
from io_util import getFileName, logger
from data import getRunString

def mkdirForRestartFile(restart_file, lf_restart_file):
    _dir = os.path.dirname(os.path.abspath(os.path.expanduser(restart_file)))
    if not os.path.exists(_dir):
        os.makedirs(_dir)

    _dir = os.path.dirname(os.path.abspath(os.path.expanduser(lf_restart_file)))
    if not os.path.exists(_dir):
        os.makedirs(_dir)

    return True


def mkdirBackup(runNo):
    _runString = getRunString(runNo)
    _rodsBackup = config.get('irods', 'rods_backup')
    _rawDataPrefix = config.get('data', 'raw_data_prefix')
    _nexusDataPrefix = config.get('data', 'nexus_data_prefix')
    _prefix = 'imkdir -p '

    # mkdir for nexus
    _tmp = _prefix + _rodsBackup.strip() + _nexusDataPrefix.strip() + _runString
    subprocess.check_output(_tmp, shell=True)

    # mkdir for raw
    _prefix += _rodsBackup.strip() + _rawDataPrefix.strip()
    _prefix += _runString

    _tmp = _prefix + "/Control"
    subprocess.check_output(_tmp, shell=True)
    
    _tmp = _prefix + "/Detector"
    subprocess.check_output(_tmp, shell=True)
    
    _tmp = _prefix +"/Monitor1/Histogram"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor2/Histogram"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor3/Histogram"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor1/Event"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor2/Event"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor3/Event"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Software"
    subprocess.check_output(_tmp, shell=True)

    return True

def mkdirPublic(runNo):
    _runString = getRunString(runNo)
    _rodsPublic = config.get('irods', 'rods_public')
    _rawDataPrefix = config.get('data', 'raw_data_prefix')
    _nexusDataPrefix = config.get('data', 'nexus_data_prefix')
    _prefix = 'imkdir -p '

    # mkdir for nexus
    _tmp = _prefix + _rodsPublic.strip() + _nexusDataPrefix.strip() + _runString
    subprocess.check_output(_tmp, shell=True)

    # mkdir for raw
    _prefix += _rodsPublic.strip() + _rawDataPrefix.strip()
    _prefix += _runString

    _tmp = _prefix  + "/Control"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Detector"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor1/Histogram"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor2/Histogram"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor3/Histogram"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor1/Event"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor2/Event"
    subprocess.check_output(_tmp, shell=True)

    _tmp = _prefix + "/Monitor3/Event"
    subprocess.check_output(_tmp, shell=True)

def putBackup(sourcePath, targetPath):
    _retries = config.get('irods', 'retries')
    _resc = config.get('irods', 'rods_backup_resc')
    _restartFile = config.get('irods', 'restart_file')
    _lfRestartFile = config.get('irods', 'lf_restart_file')

    mkdirForRestartFile(_restartFile, _lfRestartFile)

    _putComOption = "-aKrTfP -X " + _restartFile + " --retries "+ str(_retries) + " --lfrestart " + _lfRestartFile
    #putComOption="-rTP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile

    _tmp = "iput -R " + _resc + " " + _putComOption + " " + sourcePath + " " + targetPath
    _r = subprocess.check_call(_tmp, shell=True)

    if _r != 0 :
        raise Exception('Transfer to backup zone failed.')

    return True

def putPublic(sourcePath, targetPath):
    _retries = config.get('irods', 'retries')
    _resc = config.get('irods', 'rods_public_resc')
    _restartFile = config.get('irods', 'restart_file')
    _lfRestartFile = config.get('irods', 'lf_restart_file')

    mkdirForRestartFile(_restartFile, _lfRestartFile)

    _putComOption = "-aKrTfP -X " + _restartFile + " --retries "+ str(_retries) + " --lfrestart " + _lfRestartFile

    _tmp = "iput -R " + _resc + " " + _putComOption + " " + sourcePath + " " + targetPath
    _r = subprocess.check_call(_tmp, shell=True)

    if _r != 0 :
        raise Exception('Transfer to public zone failed.')

    return True

def transferNexusToPublic(runNo, nexusFiles):
    runString = getRunString(runNo)
    logger.info("Begining transfer NeXus to public: %s", runString)
    _rodsPublic = config.get('irods', 'rods_public')
    mkdirPublic(runNo)
    _b = time.time()

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  nexusFiles:
        sourcePath = _fromlocation
        targetPath = _rodsPublic + _tolocation
        putPublic(sourcePath, targetPath)

    logger.info("End transfer NeXus to public: %s, time %is", runString, time.time()-_b)
    return True

def transferNexusToBackup(runNo, nexusFiles):
    runString = getRunString(runNo)
    logger.info("Begining transfer NeXus to backup: Run %s", runString)
    _rodsBackup = config.get('irods', 'rods_backup')
    mkdirBackup(runNo)
    _b = time.time()

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  nexusFiles:
        sourcePath = _fromlocation
        targetPath = _rodsBackup + _tolocation
        putBackup(sourcePath, targetPath)

    logger.info("End transfer NeXus to backup: Run %s, time %is", runString, time.time()-_b)
    return True

def transferRawToPublic(runNo, controlFiles, detectorFiles, monitor1hisFiles, monitor2hisFiles, monitor3hisFiles, monitor1evtFiles, monitor2evtFiles, monitor3evtFiles):
    logger.info('Begining transfer raw data to public: Run %s', runNo)
    _rodsPublic = config.get('irods', 'rods_public')
    mkdirPublic(runNo)
    _b = time.time()

    for fileList in [controlFiles, detectorFiles, monitor1hisFiles, monitor2hisFiles, monitor3hisFiles, monitor1evtFiles, monitor2evtFiles, monitor3evtFiles]:
        for _, _, _filesize, _fromlocation, _tolocation, _, _ in  fileList:
            sourcePath =_fromlocation
            targetPath = _rodsPublic + _tolocation
            putPublic(sourcePath, targetPath)

    logger.info("End transfer raw to public: %is", time.time()-_b)
    return True

def transferRawToBackup(runNo, controlFiles, detectorFiles, monitor1hisFiles, monitor2hisFiles, monitor3hisFiles, monitor1evtFiles, monitor2evtFiles, monitor3evtFiles, softwareFiles):
    logger.info('Begining transfer raw data to backup: Run %s', runNo)
    _rodsBackup = config.get('irods', 'rods_backup')
    mkdirBackup(runNo)
    _b = time.time()

    for fileList in [controlFiles, detectorFiles, monitor1hisFiles, monitor2hisFiles, monitor3hisFiles, monitor1evtFiles, monitor2evtFiles, monitor3evtFiles, softwareFiles]:
        for _, _, _filesize, _fromlocation, _tolocation, _, _ in  fileList:
            sourcePath =_fromlocation
            targetPath = _rodsBackup + _tolocation
            putBackup(sourcePath, targetPath)

    logger.info("End transfer raw to backup: %is", time.time()-_b)
    return True

def transferNexusToCloud(nexusPath, runNo, investigationName):
    logger.info('Begining transfer NeXus data to cloud: Run %s', runNo)
       
    _b = time.time()
    runString = getRunString(runNo)

    _files=[]
    try:
        _files = glob.glob(nexusPath + "*.nxs")
        logger.debug('NeXus files found: %s', _files)
    except Exception as ex:
        logger.error(ex)
        return False

    filelist = []
    _cloudDataPrefix = config.get('data', 'cloud_data_prefix')
    for f in _files:
        _filename = getFileName(f)
        _fromlocation = f
        _tolocation = _cloudDataPrefix + investigationName + "/" + runString + "/" + _filename
        filelist.append([_fromlocation, _tolocation])

    _cmd = "mkdir -p " + _cloudDataPrefix + investigationName + "/" + runString
    logger.debug('Perform command: %s', _cmd)
    subprocess.check_output(_cmd, shell = True)
    
    for f in filelist:
        _fromlocation, _tolocation = f
        _cmd = "/bin/cp " + _fromlocation + " " + _tolocation
        _cmd = shlex.split(_cmd)
        logger.debug('Transfer %s to %s', _fromlocation, _tolocation)
        subprocess.check_call(_cmd, shell = False)

    logger.info("End transfer NeXus to cloud: %is", time.time()-_b)
    return True

