#!/bin/bash

set -u
RUN="$1"

source ./conf.sh

logPath="~/irods_transfer"
retries=3
restartFile="$logPath/restartfile"
lfRestartFile="$logPath/lfrestartfile"
errorLog="$logPath/error.log"
log="$logPath/log.log"
putComOption="-KrTf -X $restartFile --retries $retries --lfrestart $lfRestartFile"

mkdir -p "$logPath"
#echo "$putComOption"

#Upload to raw backup

# Control for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Control/$RUN"
targetPath="$backupRawdataPrefix/BL18/Control/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Detector for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Detector/$RUN"
targetPath="$backupRawdataPrefix/BL18/Detector/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 histogram for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Histogram/Monitor1/$RUN"
targetPath="$backupRawdataPrefix/BL18/Monitor/Histogram/Monitor1/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 event for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Event/Monitor1/$RUN"
targetPath="$backupRawdataPrefix/BL18/Monitor/Event/Monitor1/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 histogram for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Histogram/Monitor2/$RUN"
targetPath="$backupRawdataPrefix/BL18/Monitor/Histogram/Monitor2/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 event for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Event/Monitor2/$RUN"
targetPath="$backupRawdataPrefix/BL18/Monitor/Event/Monitor2/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 histogram for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Histogram/Monitor3/$RUN"
targetPath="$backupRawdataPrefix/BL18/Monitor/Histogram/Monitor3/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 event for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Event/Monitor3/$RUN"
targetPath="$backupRawdataPrefix/BL18/Monitor/Event/Monitor3/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Note: BL02 has only one monitr: Monitor1

# Upload to NeXus backup
sourcePathPrefix=/opt/CSNSDATA/nexus/TS1   # TODO: need to be edited
sourcePath="$sourcePathPrefix/BL18/$RUN"
targetPath="$backupNexusdataPrefix/BL18/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

###### Upload to user data #######

# Control for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Control/$RUN"
targetPath="$userRawdataPrefix/BL18/Control/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Detector for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Detector/$RUN"
targetPath="$userRawdataPrefix/BL18/Detector/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 histogram for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Histogram/Monitor1/$RUN"
targetPath="$userRawdataPrefix/BL18/Monitor/Histogram/Monitor1/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 event for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Event/Monitor1/$RUN"
targetPath="$userRawdataPrefix/BL18/Monitor/Event/Monitor1/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 histogram for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Histogram/Monitor2/$RUN"
targetPath="$userRawdataPrefix/BL18/Monitor/Histogram/Monitor2/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor2 event for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Event/Monitor2/$RUN"
targetPath="$userRawdataPrefix/BL18/Monitor/Event/Monitor2/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 histogram for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Histogram/Monitor3/$RUN"
targetPath="$userRawdataPrefix/BL18/Monitor/Histogram/Monitor3/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor3 event for BL18
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL18/Monitor/Event/Monitor3/$RUN"
targetPath="$userRawdataPrefix/BL18/Monitor/Event/Monitor3/"
echo input -R "$userResc" --acl "read $bl18admin" "$putComOption" "$sourcePath" "$targetPath"

# Upload to NeXus
sourcePathPrefix=/opt/CSNSDATA/nexus/TS1   # TODO: need to be edited
sourcePath="$sourcePathPrefix/BL18/$RUN"
targetPath="$userNexusdataPrefix/BL18/"
owner="lhhe"
echo input -R "$userResc" --acl "read $bl18admin;read $owner" "$putComOption" "$sourcePath" "$targetPath"

