#!/bin/bash

set -u
RUN="$1"

source ./conf.sh

logPath="~/irods_transfer"
retries=3
restartFile="$logPath/restartfile"
lfRestartFile="$logPath/lfrestartfile"
errorLog="$logPath/error.log"
log="$logPath/log.log"
putComOption="-KrTf -X $restartFile --retries $retries --lfrestart $lfRestartFile"

mkdir -p "$logPath"
#echo "$putComOption"

#Upload to raw backup

# Control for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Control/$RUN"
targetPath="$backupRawdataPrefix/BL02/Control/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Detector for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Detector/$RUN"
targetPath="$backupRawdataPrefix/BL02/Detector/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 histogram for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Monitor/Histogram/Monitor1/$RUN"
targetPath="$backupRawdataPrefix/BL02/Monitor/Histogram/Monitor1/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 event for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Monitor/Event/Monitor1/$RUN"
targetPath="$backupRawdataPrefix/BL02/Monitor/Event/Monitor1/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

# Note: BL02 has only one monitr: Monitor1

# Upload to NeXus backup
sourcePathPrefix=/opt/CSNSDATA/nexus/TS1   # TODO: need to be edited
sourcePath="$sourcePathPrefix/BL02/$RUN"
targetPath="$backupNexusdataPrefix/BL02/"
echo input -R "$backupResc" "$putComOption" "$sourcePath" "$targetPath"

###### Upload to user data #######

# Control for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Control/$RUN"
targetPath="$userRawdataPrefix/BL02/Control/"
echo input -R "$userResc" --acl "read $bl02admin" "$putComOption" "$sourcePath" "$targetPath"

# Detector for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Detector/$RUN"
targetPath="$userRawdataPrefix/BL02/Detector/"
echo input -R "$userResc" --acl "read $bl02admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 histogram for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Monitor/Histogram/Monitor1/$RUN"
targetPath="$userRawdataPrefix/BL02/Monitor/Histogram/Monitor1/"
echo input -R "$userResc" --acl "read $bl02admin" "$putComOption" "$sourcePath" "$targetPath"

# Monitor1 event for BL02
sourcePathPrefix=/opt/CSNSDATA/TS1
sourcePath="$sourcePathPrefix/BL02/Monitor/Event/Monitor1/$RUN"
targetPath="$userRawdataPrefix/BL02/Monitor/Event/Monitor1/"
echo input -R "$userResc" --acl "read $bl02admin" "$putComOption" "$sourcePath" "$targetPath"

# Note: BL02 has only one monitr: Monitor1

# Upload to NeXus
sourcePathPrefix=/opt/CSNSDATA/nexus/TS1   # TODO: need to be edited
sourcePath="$sourcePathPrefix/BL02/$RUN"
targetPath="$userNexusdataPrefix/BL02/"
owner="tzhu"
echo input -R "$userResc" --acl "read $bl02admin;read $owner" "$putComOption" "$sourcePath" "$targetPath"

