#!/bin/bash

# Usage: $0 RUN_NUMBER. Example: $0 RUN0000001

set -u
#proposal="$1"
RUN="RUN0000353"

#source ./conf.sh

addGroup() {
	local user="$1"
	local group="$2"
	echo iadmin mkuser "$user#$zone" rodsuser
	echo iadmin mkgroup "$group"
	echo iadmin atg "$group" "$user#$zone"
}

#logPath="~/irods_transfer"
#retries=3
#restartFile="$logPath/restartfile"
#lfRestartFile="$logPath/lfrestartfile"
#errorLog="$logPath/error.log"
#log="$logPath/log.log"
#putComOption="-KrTf -X $restartFile --retries $retries --lfrestart $lfRestartFile"
#
#mkdir -p "$logPath"
#
addACL() {
	local bl="$1"
	local runId="$2"
	local acl="$3"
	#imkdir -p "/csnsZone/home/public/nexus/CSNS/TS1/$bl/$runId"
	ichmod -r "$acl" "/csnsZone/home/public/nexus/CSNS/TS1/$bl/$runId"
	# ichmod -r read $bl01usergroup /csnsZone/home/public/nexus/CSNS/TS1/BL01/RUN0000001
	# ichmod -r read $bl02usergroup /csnsZone/home/public/nexus/CSNS/TS1/BL02/RUN0000001
	# ichmod -r read $bl18usergroup /csnsZone/home/public/nexus/CSNS/TS1/BL18/RUN0000001
}

prepareCollection() {
	local bl="$1"
	local runNo="$2"
	#local acl="$3"
	imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Control"
	imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Detector"
	imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Monitor/Event/Monitor1"
	imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Monitor/Histogram/Monitor1"

	if [ "$bl"x = "BL01"x ] || [ "$bl"x = "BL18"x ]; then
		imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Monitor/Event/Monitor2"
		imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Monitor/Event/Monitor3"
		imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Monitor/Histogram/Monitor2"
		imkdir -p "/csnsZone/home/public/raw/CSNS/TS1/$bl/$runNo/Monitor/Histogram/Monitor3"
	fi

	imkdir -p "/csnsZone/home/public/nexus/CSNS/TS1/$bl/$runNo"
	#ichmod -r "$acl" "/csnsZone/home/public/nexus/CSNS/TS1/$bl/$runNo"
	#ichmod -r read bl01usergroup /csnsZone/home/public/nexus/CSNS/TS1/BL01/$RUN
	#ichmod -r read bl02usergroup /csnsZone/home/public/nexus/CSNS/TS1/BL02/$RUN
	#ichmod -r read bl18usergroup /csnsZone/home/public/nexus/CSNS/TS1/BL18/$RUN

	imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Control"
	imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Detector"
	imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Monitor/Event/Monitor1"
	imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Monitor/Histogram/Monitor1"

	if [ "$bl"x = "BL01"x ] || [ "$bl"x = "BL18"x ]; then
		imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Monitor/Event/Monitor2"
		imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Monitor/Event/Monitor3"
		imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Monitor/Histogram/Monitor2"
		imkdir -p "/csnsZone/home/rods/raw/CSNS/TS1/$bl/$runNo/Monitor/Histogram/Monitor3"
	fi

	imkdir -p "/csnsZone/home/rods/nexus/CSNS/TS1/$bl/$runNo"
}

prepareCollection "BL18" "$RUN"
