#!/bin/bash

source ./conf.sh

set -u

#zone="csnsZone"
#bl01admin="bl01admin"
#bl02admin="bl02admin"
#bl18admin="bl18admin"
#csnsuser="csnsuser"

# Create user and group
iadmin mkuser "lhhe#$zone" rodsuser
iadmin mkuser "tzhu#$zone" rodsuser
iadmin mkuser "taoj#$zone" rodsuser

iadmin mkgroup "$bl01admin"
iadmin mkgroup "$bl02admin"
iadmin mkgroup "$bl18admin"
iadmin mkgroup "$csnsuser"
iadmin mkgroup "$bl01usergroup"
iadmin mkgroup "$bl02usergroup"
iadmin mkgroup "$bl18usergroup"

iadmin atg "$bl01admin" "taoj#$zone"
iadmin atg "$bl02admin" "tzhu#$zone"
iadmin atg "$bl18admin" "lhhe#$zone"
iadmin atg "$csnsuser" "taoj#$zone"
iadmin atg "$csnsuser" "tzhu#$zone"
iadmin atg "$csnsuser" "lhhe#$zone"

############### For data access ##################
## Prepare path and ACL for raw data
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01
ichmod read $bl01admin /csnsZone/home/public/raw
ichmod read $bl01admin /csnsZone/home/public/raw/CSNS
ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1
ichmod read $bl02admin /csnsZone/home/public/raw
ichmod read $bl02admin /csnsZone/home/public/raw/CSNS
ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1
ichmod read $bl18admin /csnsZone/home/public/raw
ichmod read $bl18admin /csnsZone/home/public/raw/CSNS
ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1
ichmod -r read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01
imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL02
ichmod -r read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02
imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18
ichmod -r read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18

# For BL01 raw data
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Control
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Detector
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor1
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor2
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor3
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor1
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor2
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor3
##ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Control
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Detector
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/Monitor
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor1
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor2
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor3
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor1
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor2
#ichmod read $bl01admin /csnsZone/home/public/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor3
#
## For BL02 raw data
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Control
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Detector
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Monitor/Event/Monitor1
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Monitor/Histogram/Monitor1
##ichmod -r read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Control
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Detector
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/Monitor
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Monitor/Event
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Monitor/Event/Monitor1
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Monitor/Histogram
#ichmod read $bl02admin /csnsZone/home/public/raw/CSNS/TS1/BL02/$RUN/Monitor/Histogram/Monitor1
#
## For BL18 raw data
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Control
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Detector
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor1
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor2
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor3
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor1
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor2
#imkdir -p /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor3
##ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Control
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Detector
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/Monitor
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor1
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor2
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor3
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor1
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor2
#ichmod read $bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor3

## Prepare path and ACL for NeXus data
imkdir -p /csnsZone/home/public/nexus/CSNS/TS1/BL01
imkdir -p /csnsZone/home/public/nexus/CSNS/TS1/BL02
imkdir -p /csnsZone/home/public/nexus/CSNS/TS1/BL18
ichmod read $csnsuser /csnsZone/home/public/nexus
ichmod read $csnsuser /csnsZone/home/public/nexus/CSNS
ichmod read $csnsuser /csnsZone/home/public/nexus/CSNS/TS1
ichmod read $csnsuser /csnsZone/home/public/nexus/CSNS/TS1/BL01
ichmod read $csnsuser /csnsZone/home/public/nexus/CSNS/TS1/BL02
ichmod read $csnsuser /csnsZone/home/public/nexus/CSNS/TS1/BL18
# For instrument admin
ichmod -r read $bl01admin /csnsZone/home/public/nexus/CSNS/TS1/BL01
ichmod -r read $bl02admin /csnsZone/home/public/nexus/CSNS/TS1/BL02
ichmod -r read $bl18admin /csnsZone/home/public/nexus/CSNS/TS1/BL18

################# Prepare path for data backup #####################
# For raw data
imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01
imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL02
imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18

## For BL01 raw data
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Control
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Detector
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor1
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor2
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Monitor/Event/Monitor3
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor1
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor2
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL01/$RUN/Monitor/Histogram/Monitor3

## For BL02 raw data
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL02/$RUN/Control
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL02/$RUN/Detector
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL02/$RUN/Monitor/Event/Monitor1
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL02/$RUN/Monitor/Histogram/Monitor1

## For BL18 raw data
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Control
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Detector
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor1
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor2
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Monitor/Event/Monitor3
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor1
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor2
#imkdir -p /csnsZone/home/rods/raw/CSNS/TS1/BL18/$RUN/Monitor/Histogram/Monitor3

## For nexus data
imkdir -p /csnsZone/home/rods/nexus/CSNS/TS1/BL01
imkdir -p /csnsZone/home/rods/nexus/CSNS/TS1/BL02
imkdir -p /csnsZone/home/rods/nexus/CSNS/TS1/BL18
