#!/usr/bin/python
import sys
import os
import time
import glob
import sqlite3
import re
import xml.etree.ElementTree as ET
from xml.dom import minidom
import json
import ssl
import urllib
import urllib2
import subprocess
import threading

from sqlalchemy import Column, String, create_engine
from sqlalchemy.orm import sessionmaker
from sqlalchemy.ext.declarative import declarative_base
from sqlalchemy import create_engine, Table, Column, Integer, String, MetaData, ForeignKey

ssl._create_default_https_context = ssl._create_unverified_context

Base = declarative_base()
class record(Base):

    __tablename__ = 'BL18'

    id = Column(Integer, primary_key=True)
    beamline = Column(String(64), nullable=False)
    run = Column(String(64), nullable=False, index=True)
    ctrl = Column(Integer, nullable=False)
    daq = Column(Integer, nullable=False)
    monhis1 = Column(Integer, nullable=False)
    monhis2 = Column(Integer, nullable=False)
    monhis3 = Column(Integer, nullable=False)
    monevt1 = Column(Integer, nullable=False)
    monevt2 = Column(Integer, nullable=False)
    monevt3 = Column(Integer, nullable=False)
    nexus = Column(Integer, nullable=False)
    begin = Column(String(64), nullable=True)
    end = Column(String(64), nullable=True)
    stat = Column(Integer, nullable=False, index=True)

    def __repr__(self):
        return '%s(%r)' % (self.__class__.__name__, self.run)

CTRLpath="/opt/CSNSDATA/TS1/BL18/Control/"
DAQpath="/opt/CSNSDATA/TS1/BL18/DAQ/"
MONH1path="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/Monitor1/"
MONH2path="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/Monitor2/"
MONH3path="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/Monitor3/"
MONE1path="/opt/CSNSDATA/TS1/BL18/Monitor/Event/Monitor1/"
MONE2path="/opt/CSNSDATA/TS1/BL18/Monitor/Event/Monitor2/"
MONE3path="/opt/CSNSDATA/TS1/BL18/Monitor/Event/Monitor3/"
Nexuspath="/home/transfer/nexus/CSNSDATA/TS1/BL18/"
softwarePath="/home/transfer/xml/CSNSDATA/TS1/BL18/"

rodsbackup="/csnsZone/home/rods"
rodsworkspace="/csnsZone/home/public"

global icatTime
global sessionId, facilityId, investigationId

global BLname, BLfullname
BLname="lhhe"
BLfullname="Lunhua He"

dmurl="https://dm.csns.ihep.ac.cn:8181"
#=========================================================================================
def getSessionId():
    url=dmurl+"/icat/session"
    header={'content-type': 'application/x-www-form-urlencoded'}
    body = {'json': '{"plugin":"db", "credentials":[{"username":"dataingestor"}, {"password":"sanlie_123"}]}'}
    data = urllib.urlencode(body)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()
    sessionId=json.loads(_tmp)["sessionId"]
    return sessionId

def getFacilityId(sessionId):
    body="SELECT f.id FROM Facility f WHERE f.name='CSNS'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()
    _tmp=json.loads(_tmp)
    return _tmp[0]

def getInstrumentId(sessionId, name="BL18"):
    if name=="BL01":
        nickname="SANS"
    elif name=="BL18":
        nickname="RM"
    elif name=="BL18":
        nickname="GPPD"
    else:
        pass

    body="SELECT f FROM Instrument f WHERE f.facility.name='CSNS'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()
    
    _tmp=json.loads(_tmp)

    _ins=[]
    for f in _tmp:
        _ins.append(f['Instrument'])

    for f in _ins:
        if f['name']==name or f['name']==nickname:
            _id=f['id']
            break
    return _id

def setUser(sessionId, name, fullname):
    name="ldap/"+name

    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    body={}
    body['sessionId']=sessionId
    _user='[{"User":{"name":"'+name+'","fullName":"'+fullname+'"'+'}}]'
    body['entities']=_user
    
    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    # entry id list
    return  _tmp

def getUserId(sessionId, name):
    body ="SELECT f FROM User f where f.name="+"'"+name+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['User']['id']

def getInvestigationTypeId(sessionId, name="commissioning"):
    body = "SELECT f FROM InvestigationType f WHERE f.facility.name='CSNS' and f.name="+"'"+name+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['InvestigationType']['id']

def getInvestigationId(sessionId, investigationName, visitName):
    body="SELECT f FROM Investigation f WHERE f.facility.name='CSNS' and f.name="+"'"+investigationName+"' and f.visitId="+"'"+visitName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['Investigation']['id']

def setSample(sessionId, investigationId, sampleTypeId, sampleName="unknown"):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Sample":{"type":{"id":sampleTypeId},"investigation":{"id":investigationId},"name":"sampleName"}}]'

    entities =re.sub('sampleTypeId', str(sampleTypeId), entities)
    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('sampleName', sampleName, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]


def setSampleType(sessionId, facilityId, sampleTypeName="unknown", molecularFormula="unknown"):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"SampleType":{"facility":{"id":facilityId},"molecularFormula":"molecularFormulaName","name":"sampleTypeName"}}]'
    
    entities =re.sub('facilityId', str(facilityId), entities)
    entities =re.sub('molecularFormulaName', molecularFormula, entities)
    entities =re.sub('sampleTypeName', sampleTypeName, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def getSampleTypeId(sessionId, sampleTypeName):
    body = "SELECT f FROM SampleType f WHERE f.facility.name='CSNS' and f.name="+"'"+sampleTypeName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['SampleType']['id']

def getSampleId(sessionId, investigationId, sampleName):
    body = "SELECT f FROM Sample f WHERE f.investigation.id="+investigationId+" and f.name="+"'"+sampleName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['Sample']['id']

def setParameterType(sessionId, facilityId, paraname, paraunit):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"ParameterType":{"facility":{"id":facilityId},"applicableToDataCollection":true,"applicableToDatafile":true,"applicableToDataset":true,"applicableToInvestigation":true, "applicableToSample":true,"name":"paraname","units":"paraunit","valueType":"NUMERIC"}}]'
    entities =re.sub('facilityId', str(facilityId), entities)
    entities =re.sub('paraname', paraname, entities)
    entities =re.sub('paraunit', paraunit, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def getParameterTypeId(sessionId, name, units):
    body = "SELECT f FROM ParameterType f WHERE f.facility.name='CSNS' and f.name="+"'"+name+"' and f.units="+"'"+units+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['ParameterType']['id']

def getDatasetTypeId(sessionId, name):
    body = "SELECT f FROM DatasetType f WHERE f.facility.name='CSNS' and f.name="+"'"+name+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['DatasetType']['id']

def getDatasetId(sessionId, investigationId, datasetName):
    datasetName='__csns__'+datasetName
    body = "SELECT f FROM Dataset f WHERE f.investigation.id="+investigationId+" and f.name="+"'"+datasetName+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['Dataset']['id']

def setInvestigation(sessionId, facilityId, investigationTypeId,investigationName, titleName, visitName):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Investigation":{"facility":{"id":facilityId},"type":{"id":investigationTypeId},"name":"investigationName", "title":"titleName","visitId":"visitName"}}]'
    entities =re.sub('facilityId', str(facilityId), entities)
    entities =re.sub('investigationTypeId', str(investigationTypeId), entities)
    entities =re.sub('investigationName', str(investigationName), entities)
    entities =re.sub('titleName', titleName, entities)
    entities =re.sub('visitName', visitName, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setInvestigationUser(sessionId, investigationId, userId):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"InvestigationUser":{"investigation":{"id":investigationId},"user":{"id":userId},"role":"primary"}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('userId', str(userId), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setInvestigationSample(sessionId, investigationId, sampleTypeId, sampleName):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Sample":{"type":{"id":sampleTypeId},"investigation":{"id":investigationId},"name":"sampleName"}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('sampleTypeId', str(sampleTypeId), entities)
    entities =re.sub('sampleName', str(sampleName), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]


def setInvestigationInstrument(sessionId, investigationId, instrumentId):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"InvestigationInstrument":{"investigation":{"id":investigationId},"instrument":{"id":instrumentId}}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('instrumentId', str(instrumentId), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setDataset(sessionId, investigationId, datasetTypeId, sampleId, datasetName, dataLocation, startDatetime, endDatetime, dataDescription):
    datasetName="__csns__"+datasetName
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    if startDatetime=="unknown" or endDatetime=="unknown":
        entities='[{"Dataset":{"investigation":{"id":investigationId},"sample":{"id":sampleId},"type":{"id":datasetTypeId},"complete":true,"location":"dataLocation", "name":"datasetName","description":"dataDescription"}}]'
    else:
        entities='[{"Dataset":{"investigation":{"id":investigationId},"sample":{"id":sampleId},"type":{"id":datasetTypeId},"complete":true,"location":"dataLocation", "name":"datasetName","startDate":"startDatetime","endDate":"endDatetime","description":"dataDescription"}}]'

    entities =re.sub('investigationId', str(investigationId), entities)
    entities =re.sub('datasetTypeId', str(datasetTypeId), entities)
    entities =re.sub('sampleId', str(sampleId), entities)
    entities =re.sub('datasetName', str(datasetName), entities)
    entities =re.sub('dataLocation', str(dataLocation), entities)
    entities =re.sub('startDatetime', str(startDatetime), entities)
    entities =re.sub('endDatetime', str(endDatetime), entities)
    entities =re.sub('dataDescription', str(dataDescription), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)

    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def getDatafileFormatId(sessionId, datafileFormatName, datafileFormatVersion):
    body="SELECT f FROM DatafileFormat f WHERE f.facility.name='CSNS' and f.name="+"'"+datafileFormatName+"' and f.version="+"'"+datafileFormatVersion+"'"
    data = urllib.quote(body)
    url=dmurl+"/icat/entityManager?sessionId="+sessionId + "&query="+data
    req = urllib2.Request(url)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)[0]
    return _tmp['DatafileFormat']['id']

def setDatasetParameter(sessionId, datasetId, parameterTypeId, paraValue):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"DatasetParameter":{"dataset":{"id":datasetId},"type":{"id":parameterTypeId},"stringValue":"paraValue"}}]'
    
    entities =re.sub('datasetId', str(datasetId), entities)
    entities =re.sub('parameterTypeId', str(parameterTypeId), entities)
    entities =re.sub('paraValue', paraValue, entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

def setDatafile(sessionId, datasetId, datafileFormatId, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation):
    url=dmurl+"/icat/entityManager"
    header={'content-type': 'application/x-www-form-urlencoded'}

    entities='[{"Datafile":{"dataset":{"id":datasetId},"datafileFormat":{"id":datafileFormatId},"datafileCreateTime":"dataCreateTime","description":"dataDescription","fileSize":dataSize,"location":"dataLocation","name":"datafileName"}}]'

    entities =re.sub('datasetId', str(datasetId), entities)
    entities =re.sub('datafileFormatId', str(datafileFormatId), entities)
    entities =re.sub('datafileName', str(datafileName), entities)
    entities =re.sub('dataCreateTime', str(dataCreateTime), entities)
    entities =re.sub('dataDescription', str(dataDescription), entities)
    entities =re.sub('dataSize', str(dataSize), entities)
    entities =re.sub('dataLocation', str(dataLocation), entities)

    body={}
    body['sessionId']=sessionId
    body['entities'] = entities

    data = urllib.urlencode(body)
    data=re.sub('\+', '%20', data)
    req = urllib2.Request(url, data, header)
    res = urllib2.urlopen(req)
    _tmp=res.read()

    _tmp=json.loads(_tmp)
    return  _tmp[0]

#=========================================================================================

def getCreationDate(_file):
    stat = os.stat(_file)
    try:
        _tmp=stat.st_birthtime
    except AttributeError:
        _tmp=stat.st_ctime
        #_tmp=stat.st_mtime

    #return time.strftime('%Y-%m-%dT%H:%M:%S%z', time.localtime(int(_tmp)))
    return time.strftime('%Y-%m-%dT%H:%M:%S.000+08:00', time.localtime(int(_tmp)))

def getFileSize(_file):
    #unit: byte
    #return os.path.getsize(_file)
    return int(os.stat(_file).st_size)

def getFileName(_file):
    return os.path.basename(_file)
#=========================================================================================

def getRunNoList(dir='.'):
    pattern="^RUN[0-9]{7}"
    runNo=[]

    for dirpath, dirnames, files in os.walk(dir):
        for dirname in dirnames:
            if re.match(pattern, dirname):
                runNo.append(int(dirname[3:]))

    try:
        runNo.remove(1031)
    except:
        pass
    
    runNo.sort()           
    
    return runNo

def getControlPath(runNo):
    return CTRLpath+"RUN"+str(runNo).zfill(7)+"/"

def getDetectorPath(runNo):
    _tmp1=DAQpath+"RUN"+str(runNo).zfill(7)+"/"
    _tmp2=DAQpath+"RUN"+str(runNo)+"/"
    if os.path.exists(_tmp1):
        _file=_tmp1
    else:
        if os.path.exists(_tmp2):
            _file=_tmp2
        else:
            _file= None

    return _file

def getDetectorFiles(runNo):
    _path=getDetectorPath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.xml")
        _file2=glob.glob(_path+"*.dat")
        _files=_file1 + _file2
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Detector/"+_filename
        _dataDescription="detector-raw"
        _datafileFormatName="raw_detector"    
        #for test
        #_datafileFormatName="dat"    
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def getDAQFileList(runNo):
    #ns={'d': 'http://csns.ihep.ac.cn/xml/ns/descriptor'}
    path=getDetectorPath(runNo)

    try:
        _file = glob.glob(path+"CSNS-TS1-BL18-DAQ-summary-*.xml")
        _file=_file[-1]
    except:
        return

    with open(_file) as f:
        xmlstring = f.read()
    
    if 'descriptor' in xmlstring: 
        #xmlstring=re.sub(' xmlns="[^"]+"', '', xmlstring, count=1)
        xmlstring=re.sub('\<daqDescriptor.+', '<root>', xmlstring)
        xmlstring=re.sub('\<\/daqDescriptor\>', '</root>', xmlstring, count=1)
    else:
        xmlstring = re.sub('\<\?xml version="1.0" encoding="UTF-8"\?\>', '<?xml version="1.0" encoding="UTF-8"?>\n <root>', xmlstring)
        xmlstring +="</root>"

    _files=[]

    try:
        root = ET.fromstring(xmlstring)
        _modules=root.findall("module")
        for a in _modules:
            #print a.attrib['id']
            _child=a.getchildren()[0].find(".//file")
            for _f in _child:
                _files.append(_f.text)
    except:
        pass

    return _files

def getDetectorSummaryFile(runNo):
    path=getDetectorPath(runNo)

    try:
        _file = glob.glob(path+"CSNS-TS1-BL18-DAQ-summary-*.xml")
        _file=_file[-1]
    except:
        _file=None

    return _file

def getDetectorData(runNo):
    path=getDetectorPath(runNo)

    try:
        _file = glob.glob(path+"BL18*.dat")
    except:
        _file=None

    return _file

def hasDetectorPath(runNo):
    _tmp1=DAQpath+"RUN"+str(runNo).zfill(7)+"/"
    _tmp2=DAQpath+"RUN"+str(runNo)+"/"
    if os.path.exists(_tmp1):
        _result=1
    else:
        if os.path.exists(_tmp2):
            _result=1
        else:
            _result= 0

    return _result

def hasNexusPath(runNo):
    _tmp=Nexuspath+getRunString(runNo)+"/"
    if os.path.exists(_tmp):
        _result= 1
    else:
        _result= 0

    return _result

def getMONhisPath(runNo, i):
    _path="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/Monitor"+str(i)+"/"
    _tmp=_path+"RUN"+str(runNo).zfill(7)+"/"
    if os.path.exists(_tmp):
        _file=_tmp
    else:
        _file=None
    return _file

def hasMonitorHisPath(runNo, i):
    _path="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/Monitor"+str(i)+"/"+"RUN"+str(runNo).zfill(7)+"/"

    if os.path.exists(_path):
        _result= 1
    else:
        _result= 0
    
    return _result

def getMonitorhisFiles(runNo, i):
    _path=getMONhisPath(runNo, i)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.bin")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
	if len(_filename)==34:
	    _fileDBname=_filename[0:16]+"M"+str(i)+"_"+_filename[16:]
        else:
            _fileDBname=_filename

        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Monitor"+str(i)+"/Histogram/"+_filename
        _dataDescription="monitor-histogram"
        _datafileFormatName="raw_monitor"
        # for test
        #_datafileFormatName="dat"
        filelist.append([_fileDBname, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def getMONevtPath(runNo, i):
    _path="/opt/CSNSDATA/TS1/BL18/Monitor/Event/Monitor"+str(i)+"/"
    _tmp=_path+"RUN"+str(runNo).zfill(7)+"/"
    if os.path.exists(_tmp):
        _file=_tmp
    else:
        _file=None

    return _file

def hasMonitorEvtPath(runNo, i):
    _path="/opt/CSNSDATA/TS1/BL18/Monitor/Event/Monitor"+str(i)+"/"+"RUN"+str(runNo).zfill(7)+"/"

    if os.path.exists(_path):
        _result= 1
    else:
        _result= 0

    return _result

def getMonitorevtFiles(runNo, i):
    _path=getMONevtPath(runNo, i)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.h5")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        if len(_filename)==41:
            _fileDBname=_filename[0:16]+"M"+str(i)+"_"+_filename[16:]
        else:
            _fileDBname=_filename        

	_filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Monitor"+str(i)+"/Event/"+_filename
        _dataDescription="monitor-nexus"
        _datafileFormatName="nexus_monitor"
 
        filelist.append([_fileDBname, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def getNexusPath(runNo):
    runString=getRunString(runNo)
    return "/home/transfer/nexus/CSNSDATA/TS1/BL18/"+runString+"/"

def getSoftwarePath(runNo):
    runString=getRunString(runNo)
    return "/home/transfer/xml/CSNSDATA/TS1/BL18/"+runString+"/"

def getNexusFiles(runNo):
    _path=getNexusPath(runNo)
    
    _files=[]
    try:
        _file1=glob.glob(_path+"*.nxs")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
	_filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/nexus/CSNS/TS1/BL18/" +getRunString(runNo)+"/"+_filename
        _dataDescription="nexus"
        _datafileFormatName="nexus"
        # for test
        #_datafileFormatName="nxs"
    
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    
    return filelist

def getSoftwareFiles(runNo):
    _path=getSoftwarePath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.xml")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL18/" +getRunString(runNo)+"/Software/"+_filename
        _dataDescription="software summary"
        _datafileFormatName="software_summary"
        # for test
        #_datafileFormatName="xml"

        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])

    return filelist

def getControlSummaryFile(runNo):
    _path=getControlPath(runNo)
    _files = glob.glob(_path+"CSNS-TS1-BL18-CTRL-Summary-*.xml")
    if _files:
        _file=_files[0]
    else:
        _file=None
    return _file

def getControlFiles(runNo):
    _path=getControlPath(runNo)

    _files=[]
    try:
        _file1=glob.glob(_path+"*.xml")
        _files=_file1
    except:
        pass

    filelist=[]
    for f in _files:
        _filename=getFileName(f)
        _filetime=getCreationDate(f)
        _filesize=getFileSize(f)
        _fromlocation=f
        _tolocation="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Control/"+_filename
        _dataDescription="control-raw"
        _datafileFormatName="control_summary"
        # for test
        #_datafileFormatName="xml"
    
        filelist.append([_filename, _filetime, str(_filesize), _fromlocation, _tolocation, _dataDescription, _datafileFormatName])
    return filelist

def hasControlSummaryFile(runNo):
    _path=getControlPath(runNo)
    _files = glob.glob(_path+"CSNS-TS1-BL18-CTRL-Summary-*.xml")
    if _files:
        _result= 1
    else:
        _result= 0
    return _result

def getRunTime(runNo):
    _file=getControlSummaryFile(runNo)

    tree = ET.parse(_file)
    root = tree.getroot()

    _tmp = root.findall("NXentry/start_time_utc")[0].text
    if _tmp:
        _tmp=re.sub(' ', 'T', _tmp)
        _tmp+=".000+08:00"
        beginDate=_tmp
    else:
        beginData=""

    _tmp = root.findall('NXentry/end_time_utc')[0].text
    if _tmp:
        _tmp=re.sub(' ', 'T', _tmp)
        _tmp+=".000+08:00"
        endDate=_tmp
    else:
        endData=""

    return beginDate, endDate

def readControlSummaryFile(runNo):
    _file=getControlSummaryFile(runNo)
    
    if _file is not None:
        try:
            tree = ET.parse(_file)
            root = tree.getroot()

            _tmp = root.findall("NXentry/start_time_utc")[0].text
            if _tmp:
                _tmp=re.sub(' ', 'T', _tmp)
                _tmp+=".000+08:00"
                startDatetime=_tmp
            else:
                startDatetime="unknown"

            _tmp = root.findall('NXentry/end_time_utc')[0].text
            if _tmp:
                _tmp=re.sub(' ', 'T', _tmp)
                _tmp+=".000+08:00"
                endDatetime=_tmp
            else:
                endDatetime="unknown"

            _tmp1 = root.findall('NXentry/description')[0].text
            _tmp2 = root.findall('NXentry/measurement_type')[0].text
            if _tmp1 and _tmp2:
                datasetDescription=_tmp1+":"+_tmp2
            elif _tmp1:
                datasetDescription=_tmp1
            elif _tmp2:
                datasetDescription=_tmp2
            else:
                datasetDescription="unknown"

            user_id = root.findall('NXentry/user_id')[0].text
            proposal_id = root.findall('NXentry/proposal_id')[0].text


            # create and get id from ICAT
            _tmp = root.findall("NXentry/NXinstrument/NXsample/name")[0].text
            if _tmp:
                sampleTypeName=_tmp
            else:
                sampleTypeName="unknown"

            sampleName=sampleTypeName

            _tmp = root.findall("NXentry/NXinstrument/NXsample/chemical_formula")[0].text
            if _tmp:
                sampleTypeMolecularFormula=_tmp
            else:
                sampleTypeMolecularFormula="unknown"
        except:
            startDatetime="unknown"
            endDatetime="unknown"
            datasetDescription="unknown"
            sampleTypeName="unknown"
            sampleName="unknown"
            sampleTypeMolecularFormula="unknown"

    else:
        startDatetime="unknown"
        endDatetime="unknown"
        datasetDescription="unknown"
        sampleTypeName="unknown"
        sampleName="unknown"
        sampleTypeMolecularFormula="unknown"

    datasetType="commissioning"
    investigationName="commissioning-BL18"
    investigationTitleName="commissioning-BL18"
    visitName="commissioning-BL18-0"
    datasetName=getRunString(runNo)
    dataLocation="/CSNS/TS1/BL18/"+datasetName
    
    _dict={}
    _dict['startDatetime']=startDatetime
    _dict['endDatetime']=endDatetime
    _dict['datasetType']=datasetType
    _dict['investigationName']=investigationName
    _dict['investigationTitleName']=investigationTitleName
    _dict['visitName']=visitName
    _dict['datasetName']=datasetName
    _dict['dataLocation']=dataLocation
    _dict['datasetDescription']=datasetDescription
    _dict['sampleTypeName']=sampleTypeName
    _dict['sampleName']=sampleName
    _dict['sampleTypeMolecularFormula']=sampleTypeMolecularFormula

    return _dict

def getIcatInfo():
    global BLname, BLfullname
    investigationTypeName="commissioning"
    investigationName = "commissioning-BL18"
    titleName="commissioning-BL18"
    visitName="commissioning-BL18-0"

    sessionId = getSessionId()
    facilityId = getFacilityId(sessionId)
    instrumentId = getInstrumentId(sessionId, "BL18")

    try:
        setUser(sessionId, BLname, BLfullname)
    except:
        pass

    userId=getUserId(sessionId, "ldap/"+BLname)
    #print "get userId: ", userId

    investigationTypeId = getInvestigationTypeId(sessionId, investigationTypeName)
    #print "get investigationTypeId: ", investigationTypeId

    try:
        setInvestigation(sessionId, facilityId, investigationTypeId, investigationName, titleName, visitName)
        #print "set investigationId: ", investigationId
    except:
        pass

    investigationId = getInvestigationId(sessionId, investigationName, visitName)
    #print "get investigationId: ", investigationId

    try:
        investigationUserId = setInvestigationUser(sessionId, investigationId, userId)
        #print "set investigationUserId: ", investigationUserId
    except:
        pass

    try:
        investigationInstrumentId = setInvestigationInstrument(sessionId, investigationId, instrumentId)
        #print "set investigationInstrumentId: ", investigationInstrumentId
    except:
        pass

    return sessionId, facilityId, investigationId

def setIcatDataset(sessionId, facilityId, investigationId, sampleTypeName, sampleName, molecularFormula, datasetName, dataLocation, startDatetime, endDatetime, dataDescription):
    try:
        setSampleType(sessionId, facilityId, sampleTypeName, molecularFormula)
    except:
        pass
        
    sampleTypeId = getSampleTypeId(sessionId, sampleTypeName)
    #print "get sampleTypeId: ", sampleTypeId

    try:
        setSample(sessionId, investigationId, sampleTypeId, sampleName)
        #print "set sampleId: ", sampleId
    except:
        pass

    sampleId =  getSampleId(sessionId, str(investigationId), sampleName)

    try:
        investigationSampleId= setInvestigationSample(sessionId, investigationId, sampleTypeId, sampleName)
        #print "set investigationSampleId: ", investigationSampleId
    except:
        pass
    

    datasetTypeId= getDatasetTypeId(sessionId, "raw")
    #print "get datasetTypeId: ", datasetTypeId

    try:
        setDataset(sessionId, investigationId, datasetTypeId, sampleId, datasetName, dataLocation, startDatetime, endDatetime, dataDescription)
    except:
        pass

    datasetId = getDatasetId(sessionId, str(investigationId), datasetName) 
    #print "set datasetId: ", datasetId
    
    return datasetId

def setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation):
    
    try:
        datafileFormatId = getDatafileFormatId(sessionId, datafileFormatName, datafileFormatVersion="1.0")
        #print "datafileFormatId: ", datafileFormatId
	
	setDatafile(sessionId, datasetId, datafileFormatId, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)
    except:
	print "Failed to Write Icat: ", datafileName

def writeXml(runNo, beginTime, endTime, controlFiles, detectorFiles, monitor1hisFiles,monitor2hisFiles, monitor3hisFiles,monitor1evtFiles, monitor2evtFiles,monitor3evtFiles,nexusFiles):
    #from ElementTree_pretty import prettify

    runString = getRunString(runNo)
    _tmp="mkdir -p "+getSoftwarePath(runNo)
    subprocess.check_output(_tmp, shell=True)


    top = ET.Element('root')

    child = ET.SubElement(top, 'run')
    child.text=runString

    child = ET.SubElement(top, 'begin')
    child.text=beginTime

    child = ET.SubElement(top, 'end')
    child.text=endTime

    _num=len(controlFiles)
    control = ET.SubElement(top, 'contorl')
    control.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in controlFiles:
        _file = ET.SubElement(control, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename
        
        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize
    
        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation

        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

    _num=len(detectorFiles)
    detector = ET.SubElement(top, 'detector')
    detector.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in detectorFiles:
        _file = ET.SubElement(detector, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename

        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize

        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation

        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

    for k in range(3):
        if k==0:
            _list=monitor1hisFiles
            _name='monitor1_histogram'
        elif k==1:
            _list=monitor2hisFiles
            _name='monitor2_histogram'
        elif k==2:
            _list=monitor3hisFiles
            _name='monitor3_histogram'
        else:
            pass
        
        _num=len(_list)
        _monitor = ET.SubElement(top, _name)
        _monitor.set('number',str(_num))
        for filename, filesize, filecreation, fromlocation, tolocation, _,_ in _list:
            _file = ET.SubElement(_monitor, 'file')
            _child = ET.SubElement(_file, 'filename')
            _child.text=filename

            _child = ET.SubElement(_file, 'filesize')
            _child.text=filesize

            _child = ET.SubElement(_file, 'creationtime')
            _child.text=filecreation

            _child = ET.SubElement(_file, 'from')
            _child.text=fromlocation
            
            _child = ET.SubElement(_file, 'to')
            _child.text=tolocation

    for k in range(3):
        if k==0:
            _list=monitor1evtFiles
            _name='monitor1_event'
        elif k==1:
            _list=monitor2evtFiles
            _name='monitor2_event'
        elif k==2:
            _list=monitor3evtFiles
            _name='monitor3_event'
        else:
            pass
        
        _num=len(_list)
        _monitor = ET.SubElement(top, _name)
        _monitor.set('number',str(_num))
        for filename, filesize, filecreation, fromlocation, tolocation, _,_ in _list:
            _file = ET.SubElement(_monitor, 'file')
            _child = ET.SubElement(_file, 'filename')
            _child.text=filename

            _child = ET.SubElement(_file, 'filesize')
            _child.text=filesize

            _child = ET.SubElement(_file, 'creationtime')
            _child.text=filecreation

            _child = ET.SubElement(_file, 'from')
            _child.text=fromlocation
            
            _child = ET.SubElement(_file, 'to')
            _child.text=tolocation

    _num=len(nexusFiles)
    nexus = ET.SubElement(top, 'nexus')
    nexus.set('number',str(_num))
    for filename, filesize, filecreation, fromlocation, tolocation, _,_ in nexusFiles:
        _file = ET.SubElement(nexus, 'file')
        _child = ET.SubElement(_file, 'filename')
        _child.text=filename

        _child = ET.SubElement(_file, 'filesize')
        _child.text=filesize

        _child = ET.SubElement(_file, 'creationtime')
        _child.text=filecreation

        _child = ET.SubElement(_file, 'from')
        _child.text=fromlocation

        _child = ET.SubElement(_file, 'to')
        _child.text=tolocation

    xmlstr = minidom.parseString(ET.tostring(top)).toprettyxml(indent="   ")
    with open(getSoftwarePath(runNo)+runString+".xml", "w") as f:
        f.write(xmlstr)

def setControlLocation(runNo, _filename):
    backup="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Control/"+_filename
    return backup
    
def setDetectorLocation(runNo, _filename):
    backup="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Detector/"+_filename
    return backup
    
def setMonitorhisLocation(runNo, k, _filename):
    backup="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Monitor"+str(k)+"/Histogram/"+_filename
    return backup
    
def setMonitorevtLocation(runNo, k, _filename):
    backup="/raw/CSNS/TS1/BL18/"+getRunString(runNo)+"/Monitor"+str(k)+"/Event/"+_filename
    return backup
    
def setNexusLocation(runNo, k, _filename):
    backup="/nexus/CSNS/TS1/BL18/" +getRunString(runNo)+"/"+_filename
    return backup

def getRunString(runNo):
    return "RUN"+str(runNo).zfill(7)

def writeNexusToIcat(runNo):
    global icatTime

    global sessionId, facilityId, investigationId

    if time.time()-icatTime>5400:
        icatTime=time.time()
        sessionId, facilityId, investigationId = getIcatInfo()

    conf = readControlSummaryFile(runNo)
    datasetId =setIcatDataset(sessionId, facilityId, investigationId, conf['sampleTypeName'], conf['sampleName'], conf['sampleTypeMolecularFormula'], conf['datasetName'], conf['dataLocation'], conf['startDatetime'], conf['endDatetime'], conf['datasetDescription'])

    _nexusFiles       = getNexusFiles(runNo)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _nexusFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    return True

def writeRawToIcat(runNo):
    global icatTime

    global sessionId, facilityId, investigationId

    if time.time()-icatTime>5400:
        icatTime=time.time()
        sessionId, facilityId, investigationId = getIcatInfo()

    conf = readControlSummaryFile(runNo)
    datasetId =setIcatDataset(sessionId, facilityId, investigationId, conf['sampleTypeName'], conf['sampleName'], conf['sampleTypeMolecularFormula'], conf['datasetName'], conf['dataLocation'], conf['startDatetime'], conf['endDatetime'], conf['datasetDescription'])

    _controlFiles=getControlFiles(runNo)
    _detectorFiles=getDetectorFiles(runNo)
    _monitor1hisFiles = getMonitorhisFiles(runNo, 1)
    _monitor2hisFiles = getMonitorhisFiles(runNo, 2)
    _monitor3hisFiles = getMonitorhisFiles(runNo, 3)
    _monitor1evtFiles = getMonitorevtFiles(runNo, 1)
    _monitor2evtFiles = getMonitorevtFiles(runNo, 2)
    _monitor3evtFiles = getMonitorevtFiles(runNo, 3)
    _nexusFiles       = getNexusFiles(runNo)
    _softwareFiles    = getSoftwareFiles(runNo)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _controlFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _detectorFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitor1hisFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitor2hisFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitor3hisFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitor1evtFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitor2evtFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _monitor3evtFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _nexusFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    for datafileName, dataCreateTime, dataSize,  _, dataLocation, dataDescription, datafileFormatName  in _softwareFiles:
        setIcatDatafile(sessionId, datasetId, datafileFormatName, datafileName, dataCreateTime, dataDescription, dataSize, dataLocation)

    return True

def mkdirRods(runNo):
    runString=getRunString(runNo)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Control"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Detector"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Monitor1/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Monitor2/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Monitor3/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Monitor1/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Monitor2/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Monitor3/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/raw/CSNS/TS1/BL18/"+runString+"/Software"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/rods/nexus/CSNS/TS1/BL18/"+runString
    subprocess.check_output(_tmp, shell=True) 

def mkdirPublic(runNo):
    runString=getRunString(runNo)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Control"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Detector"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Monitor1/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Monitor2/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Monitor3/Histogram"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Monitor1/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Monitor2/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/raw/CSNS/TS1/BL18/"+runString+"/Monitor3/Event"
    subprocess.check_output(_tmp, shell=True)
    _tmp = "imkdir -p "+ "/csnsZone/home/public/nexus/CSNS/TS1/BL18/"+runString
    subprocess.check_output(_tmp, shell=True)

def addGroup():
    global BLname
    _tmp="iadmin mkuser "+BLname+"#csnsZone rodsuser"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin mkgroup "+"bl18admin"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin atg bl18admin "+BLname+"#csnsZone"
    subprocess.check_output(_tmp, shell=True)

    _tmp="iadmin mkgroup "+"bl18commissioning"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin atg bl18commissioning "+BLname+"#csnsZone"
    subprocess.check_output(_tmp, shell=True)

    _tmp="iadmin mkgroup "+"csnsuser"
    subprocess.check_output(_tmp, shell=True)
    _tmp="iadmin atg csnsuser "+BLname+"#csnsZone"
    subprocess.check_output(_tmp, shell=True)

def addAcl(runNo):
    _tmp="ichmod -r read bl18commissioning /csnsZone/home/public/nexus/CSNS/TS1/BL18/"+getRunString(runNo)
    subprocess.check_output(_tmp, shell=True)
    _tmp="ichmod -r read bl18admin /csnsZone/home/public/raw/CSNS/TS1/BL18/"+getRunString(runNo)
    subprocess.check_output(_tmp, shell=True)
    _tmp="ichmod -r read bl18admin /csnsZone/home/public/nexus/CSNS/TS1/BL18/"+getRunString(runNo)
    subprocess.check_output(_tmp, shell=True)
    
def putRods(sourcePath, targetPath):
    retries=0
    backupResc="csnsBackupDataResc"
    restartFile="./rodsbase/restartFile"
    lfRestartFile="./rodsbase/lfRestartFile"

    putComOption="-KrTfP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile
    #putComOption="-rTP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile

    _tmp = "iput -R " + backupResc +" "+putComOption +" "+ sourcePath +" "+ targetPath
    
    subprocess.call(_tmp, shell=True)

    return True

def putPublic(sourcePath, targetPath):
    retries=0
    backupResc="csnsResc"
    restartFile="./rodsbase/restartFile"
    lfRestartFile="./rodsbase/lfRestartFile"

    putComOption="-KrTfP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile
    #putComOption="-rTP -X " + restartFile + " --retries "+ str(retries) + " --lfrestart " +lfRestartFile

    _tmp = "iput -R " + backupResc +" "+putComOption +" "+ sourcePath +" "+ targetPath

    subprocess.call(_tmp, shell=True)
    
    return True

def transferNexusToPublic(runNo):
    runString=getRunString(runNo)

    mkdirPublic(runNo)

    _b=time.time()

    _nexusFiles      = getNexusFiles(runNo)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _nexusFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    addAcl(runNo)

    print "Put Nexus To Public:", time.time()-_b
    return True

def transferNexusToBackup(runNo):
    runString=getRunString(runNo)

    mkdirRods(runNo)

    _b=time.time()

    _nexusFiles      = getNexusFiles(runNo)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _nexusFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    addAcl(runNo)

    print "Put Nexus To Backup:", time.time()-_b
    return True
    

def transferRawToPublic(runNo):
    runString=getRunString(runNo)

    mkdirPublic(runNo)

    _b=time.time()
    
    _controlFiles     = getControlFiles(runNo)
    _detectorFiles    = getDetectorFiles(runNo)
    _monitor1hisFiles = getMonitorhisFiles(runNo, 1)
    _monitor2hisFiles = getMonitorhisFiles(runNo, 2)
    _monitor3hisFiles = getMonitorhisFiles(runNo, 3)
    _monitor1evtFiles = getMonitorevtFiles(runNo, 1)
    _monitor2evtFiles = getMonitorevtFiles(runNo, 2)
    _monitor3evtFiles = getMonitorevtFiles(runNo, 3)

    _nexusFiles      = getNexusFiles(runNo)
    conf = readControlSummaryFile(runNo)
    writeXml(runNo, conf['startDatetime'], conf['endDatetime'], _controlFiles, _detectorFiles, _monitor1hisFiles,_monitor2hisFiles,_monitor3hisFiles, _monitor1evtFiles,  _monitor2evtFiles, _monitor3evtFiles, _nexusFiles)
    _softwareFiles       = getSoftwareFiles(runNo)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _controlFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _detectorFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor1hisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor2hisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor3hisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor1evtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor2evtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor3evtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/public"+_tolocation
        putPublic(sourcePath, targetPath)

    addAcl(runNo)

    print "Put Raw To Public:", time.time()-_b
    return True

def transferRawToBackup(runNo):
    runString=getRunString(runNo)

    mkdirRods(runNo)

    _b=time.time()
    
    _controlFiles     = getControlFiles(runNo)
    _detectorFiles    = getDetectorFiles(runNo)
    _monitor1hisFiles = getMonitorhisFiles(runNo, 1)
    _monitor2hisFiles = getMonitorhisFiles(runNo, 2)
    _monitor3hisFiles = getMonitorhisFiles(runNo, 3)
    _monitor1evtFiles = getMonitorevtFiles(runNo, 1)
    _monitor2evtFiles = getMonitorevtFiles(runNo, 2)
    _monitor3evtFiles = getMonitorevtFiles(runNo, 3)

    _nexusFiles       = getNexusFiles(runNo)
    conf = readControlSummaryFile(runNo)
    writeXml(runNo, conf['startDatetime'], conf['endDatetime'], _controlFiles, _detectorFiles, _monitor1hisFiles,_monitor2hisFiles,_monitor3hisFiles, _monitor1evtFiles,  _monitor2evtFiles, _monitor3evtFiles, _nexusFiles)
    _softwareFiles       = getSoftwareFiles(runNo)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _controlFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _detectorFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor1hisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor2hisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor3hisFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor1evtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor2evtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _monitor3evtFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    for _, _, _filesize, _fromlocation, _tolocation, _, _ in  _softwareFiles:
        sourcePath=_fromlocation
        targetPath="/csnsZone/home/rods"+_tolocation
        putRods(sourcePath, targetPath)

    addAcl(runNo)

    print "Put Raw To Backup:", time.time()-_b
    return True

# ==============================
icatTime=time.time()
sessionId, facilityId, investigationId = getIcatInfo()
# ==============================
try:
    addGroup()
except:
    pass

class main(threading.Thread):
    def __init__(self):
        threading.Thread.__init__(self)
        #self.getDb()
        self.getRemoteDb()

    def getRemoteDb(self):
        engine = create_engine('mysql+mysqlconnector://transfer:sanlie_123@mysql.csns.ihep.ac.cn/transfer_db')
        self.DBSession = sessionmaker(bind=engine)

    def openRemoteDb(self):
        self.session = self.DBSession()

    def closeRemoteDb(self):
        self.session.close()

    def insertDb(self, user):
        self.session.add(user)
        self.session.commit()

    def queryDb(self, runNo):
        runString=getRunString(runNo)
        _tmp = self.session.query(record).filter_by(run=runString).first()
        if _tmp is not None:
            _result=_tmp.stat
        else:
            _result=-1

        return _result

    def updateDb(self, runNo, stat):
        runString=getRunString(runNo)
        _tmp = self.session.query(record).filter_by(run=runString).first()
        _tmp.stat = stat
        self.session.add(_tmp)
        self.session.commit()

    def deleteDb(self, runNo):
        pass
        
    def createRecord(self, runNo):
        # ==============================
        # has control summary file
        hasControl = hasControlSummaryFile(runNo)
        conf = readControlSummaryFile(runNo)
        # ==============================
        # has detector path
        hasDetector = hasDetectorPath(runNo)
        # ==============================
        # has monitor histogram path
        hasMonitorHis1 = hasMonitorHisPath(runNo, 1)
        # ==============================
        # has monitor histogram path
        hasMonitorHis2 = hasMonitorHisPath(runNo, 2)
        # ==============================
        # has monitor histogram path
        hasMonitorHis3 = hasMonitorHisPath(runNo, 3)
        # ==============================
        # has monitor event path
        hasMonitorEvt1 = hasMonitorEvtPath(runNo, 1)
        # ==============================
        # has monitor event path
        hasMonitorEvt2 = hasMonitorEvtPath(runNo, 2)
        # ==============================
        # has monitor event path
        hasMonitorEvt3 = hasMonitorEvtPath(runNo, 3)
        # ==============================
        # has nexus path
        hasNexus = hasNexusPath(runNo)

        runString=getRunString(runNo)

        user=record(beamline = 'BL18',run =runString, ctrl=hasControl, daq=hasDetector, monhis1=hasMonitorHis1, monhis2=hasMonitorHis2, monhis3=hasMonitorHis3, monevt1=hasMonitorEvt1, monevt2=hasMonitorEvt2, monevt3=hasMonitorEvt3, nexus=hasNexus, begin=conf['startDatetime'], end=conf['endDatetime'], stat=0)

        return user

    def getDb(self):
        dbfile='bl18.db'
        if os.path.exists(dbfile):
            self.db = sqlite3.connect(dbfile,check_same_thread = False)
            self.cur = self.db.cursor()
        else:
            self.db = sqlite3.connect(dbfile,check_same_thread = False)
            self.cur = self.db.cursor()
            tb = 'CREATE TABLE data (ID INTEGER PRIMARY KEY, BEAMLINE TEXT, RUN TEXT, CTRL INTEGER, DAQ INTEGER, MONHIS1 INTEGER, MONHIS2 INTEGER, MONHIS3 INTEGER, MONEVT1 INTEGER, MONEVT2 INTEGER, MONEVT3 INTEGER, NEXUS INTEGER,  BEGIN TEXT, END TEXT, STAT INTEGER)'
            self.cur.execute(tb)
            self.db.commit()

    def openDb(self):
        dbfile='bl18.db'
        self.db = sqlite3.connect(dbfile, check_same_thread = False)
        self.cur = self.db.cursor()

    def closeDb(self):
        self.db.commit()
	self.cur.close()
	self.db.close()

    def setDb(self, runNo):
        # ==============================
        # has control summary file
        hasControl = hasControlSummaryFile(runNo)
        conf = readControlSummaryFile(runNo)
        # ==============================
        # has detector path
        hasDetector = hasDetectorPath(runNo)
        # ==============================
        # has monitor histogram path
        hasMonitorHis1 = hasMonitorHisPath(runNo, 1)
        # ==============================
        # has monitor histogram path
        hasMonitorHis2 = hasMonitorHisPath(runNo, 2)
        # ==============================
        # has monitor histogram path
        hasMonitorHis3 = hasMonitorHisPath(runNo, 3)
        # ==============================
        # has monitor event path
        hasMonitorEvt1 = hasMonitorEvtPath(runNo, 1)
        # ==============================
        # has monitor event path
        hasMonitorEvt2 = hasMonitorEvtPath(runNo, 2)
        # ==============================
        # has monitor event path
        hasMonitorEvt3 = hasMonitorEvtPath(runNo, 3)
        # ==============================
        # has nexus path
        hasNexus = hasNexusPath(runNo)

        runString=getRunString(runNo)
        self.writeDb(runString, hasControl, hasDetector, hasMonitorHis1, hasMonitorHis2, hasMonitorHis3, hasMonitorEvt1, hasMonitorEvt2, hasMonitorEvt3, hasNexus,conf['startDatetime'], conf['endDatetime'], 0)

    def deleteDb(self, STAT):
        cur = self.db.cursor()
        query = "delete from data where STAT = %d " % STAT
        cur.execute(query)
        self.db.commit()

    def writeDb(self, RUN, CTRL, DAQ, MONHIS1,MONHIS2,MONHIS3,MONEVT1,MONEVT2,MONEVT3, NEXUS, BEGIN, END, STAT):
        sqlstring = 'INSERT INTO data (ID, BEAMLINE, RUN, CTRL, DAQ, MONHIS1, MONHIS2, MONHIS3, MONEVT1, MONEVT2, MONEVT3, NEXUS,BEGIN, END, STAT) VALUES(NULL, "%s", "%s", "%d", "%d","%d", "%d", "%d","%d", "%d", "%d", "%d", "%s", "%s", "%d")' %("BL18", RUN, CTRL, DAQ, MONHIS1,MONHIS2,MONHIS3,MONEVT1,MONEVT2,MONEVT3, NEXUS, BEGIN, END, STAT)
        self.cur.execute(sqlstring)
        self.db.commit()

    def readDb(self):
        self.cur.execute('SELECT * FROM data')
        dbList = self.cur.fetchall()
        #for i in dbList:
        #    print i

    def setDbStat(self, runNo, value):
        runString=getRunString(runNo)
        _tmp ="update data set STAT='%d' where run = '%s'" % (value, runString)
        self.cur.execute(_tmp)

    def fetchDbStat(self, id):
        _tmp ="SELECT * FROM data where id = %d" % (id)
        self.cur.execute(_tmp)
        dbList = self.cur.fetchall()
        for i in dbList:
            print i

    def getDbStat(self, runNo):
        runString=getRunString(runNo)
        self.cur.execute('SELECT * FROM data where run = ?', (runString,))
        dbList = self.cur.fetchone()
        return dbList[14]

    # 0: begin
    # 1: nexus transfer to Public
    # 2: write icat
    # 3: raw transfer to Public
    # 4: write icat
    # 5: nexus transfer to Backup
    # 6: raw transfer to Backup
    def process(self):
        runNoList=getRunNoList(Nexuspath)

	self.openRemoteDb()
        for runNo in runNoList:
            stat = self.queryDb(runNo)

            if stat!=6:
                print "begin: ", runNo, stat

            if stat==-1:
                self.insertDb(user)
                stat=0
        
            if stat==0:
                success = transferNexusToPublic(runNo)
                if success:
                    self.updateDb(runNo, 1)
		    stat=1

            if stat==1:
                success = writeNexusToIcat(runNo)
                if success:
                    self.updateDb(runNo, 2)
		    stat=2

            if stat==2:
                success = transferRawToPublic(runNo)
                if success:
                    self.updateDb(runNo, 3)
		    stat=3

            if stat==3:
                success = writeRawToIcat(runNo)
                if success:
                    self.updateDb(runNo, 4)
		    stat=4

            if stat==4:
                success = transferNexusToBackup(runNo)
                if success:
                    self.updateDb(runNo, 5)
		    stat=5

            if stat==5:
                success = transferRawToBackup(runNo)
                if success:
                    self.updateDb(runNo, 6)
		    stat=6
            	    print "end: ", runNo

	    if stat==6:
                pass

	self.closeRemoteDb()
    
    def run(self):
        while True:
            self.process()
            time.sleep(60.0)
            
if __name__=="__main__":

    threadDaemon = main()
    threadDaemon.setDaemon(True)
    threadDaemon.start()
    threadDaemon.join()
    sys.exit()
