#!/usr/bin/python

import sys
import os
import epics
from epics.ca import CAThread, withInitialContext
import redis
import neon
import datetime
import time
import random
import numpy as np
import warnings
import json
from Queue import Queue
import threading
import logging
import multiprocessing
import fcntl
import logging
import subprocess
import shlex

#write = sys.stdout.write
#flush = sys.stdout.flush

#import warnings
#warnings.filterwarnings("ignore")

logger = logging.getLogger('GPPDcockpit')
hdlr = logging.FileHandler(os.getcwd()+'/GPPDcockpit.log')
formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
hdlr.setFormatter(formatter)
logger.addHandler(hdlr)
logger.setLevel(logging.DEBUG)

GPPDgroup1=[]
GPPDgroup1.append('module521')
GPPDgroup1.append('module522')
GPPDgroup1.append('module523')
GPPDgroup1.append('module531')
GPPDgroup1.append('module532')
GPPDgroup1.append('module533')
GPPDgroup1.append('module541')
GPPDgroup1.append('module542')
GPPDgroup1.append('module543')

GPPDgroup2=[]
GPPDgroup2.append('module621')
GPPDgroup2.append('module622')
GPPDgroup2.append('module623')
GPPDgroup2.append('module631')
GPPDgroup2.append('module632')
GPPDgroup2.append('module633')
GPPDgroup2.append('module641')
GPPDgroup2.append('module642')
GPPDgroup2.append('module643')

GPPDgroup3=[]
GPPDgroup3.append('module131')
GPPDgroup3.append('module132')
GPPDgroup3.append('module133')
GPPDgroup3.append('module231')
GPPDgroup3.append('module232')
GPPDgroup3.append('module233')
GPPDgroup3.append('module322')
GPPDgroup3.append('module331')
GPPDgroup3.append('module332')
GPPDgroup3.append('module333')
GPPDgroup3.append('module341')
GPPDgroup3.append('module342')
GPPDgroup3.append('module343')
GPPDgroup3.append('module422')
GPPDgroup3.append('module431')
GPPDgroup3.append('module432')
GPPDgroup3.append('module433')
GPPDgroup3.append('module441')
GPPDgroup3.append('module442')
GPPDgroup3.append('module443')

GPPDgroup4=[]
GPPDgroup4.append('monitor1')
GPPDgroup4.append('monitor2')
GPPDgroup4.append('monitor3')

GPPDdroneInfo=[]
_n=-1
for i in range(len(GPPDgroup1)):
    _n+=1
    GPPDdroneInfo.append({})
    GPPDdroneInfo[_n]['host']='10.1.33.144'
    GPPDdroneInfo[_n]['module']=GPPDgroup1[i]
    GPPDdroneInfo[_n]['pid']=-1
    GPPDdroneInfo[_n]['running']='0'
    GPPDdroneInfo[_n]['rpc']='0'
    GPPDdroneInfo[_n]['pobox']='0'
    GPPDdroneInfo[_n]['heartbeat']='/GPPD/heartbeat/detector/'+GPPDdroneInfo[_n]['host']+':'+GPPDgroup1[i]
for i in range(len(GPPDgroup2)):
    _n+=1
    GPPDdroneInfo.append({})
    GPPDdroneInfo[_n]['host']='10.1.33.143'
    GPPDdroneInfo[_n]['module']=GPPDgroup2[i]
    GPPDdroneInfo[_n]['pid']=-1
    GPPDdroneInfo[_n]['running']='0'
    GPPDdroneInfo[_n]['rpc']='0'
    GPPDdroneInfo[_n]['pobox']='0'
    GPPDdroneInfo[_n]['heartbeat']='/GPPD/heartbeat/detector/'+GPPDdroneInfo[_n]['host']+':'+GPPDgroup2[i]

for i in range(len(GPPDgroup3)):
    _n+=1
    GPPDdroneInfo.append({})
    GPPDdroneInfo[_n]['host']='10.1.33.143'
    GPPDdroneInfo[_n]['module']=GPPDgroup3[i]
    GPPDdroneInfo[_n]['pid']=-1
    GPPDdroneInfo[_n]['running']='0'
    GPPDdroneInfo[_n]['rpc']='0'
    GPPDdroneInfo[_n]['pobox']='0'
    GPPDdroneInfo[_n]['heartbeat']='/GPPD/heartbeat/detector/'+GPPDdroneInfo[_n]['host']+':'+GPPDgroup3[i]

for i in range(len(GPPDgroup4)):
    _n+=1
    GPPDdroneInfo.append({})
    GPPDdroneInfo[_n]['host']='10.1.33.143'
    GPPDdroneInfo[_n]['module']=GPPDgroup4[i]
    GPPDdroneInfo[_n]['pid']=-1
    GPPDdroneInfo[_n]['running']='0'
    GPPDdroneInfo[_n]['rpc']='0'
    GPPDdroneInfo[_n]['pobox']='0'
    GPPDdroneInfo[_n]['heartbeat']='/GPPD/heartbeat/detector/'+GPPDdroneInfo[_n]['host']+':'+GPPDgroup4[i]

fh=0
def run_once():
    global fh
    fh=open(os.path.realpath(__file__),'r')
    try:
        fcntl.flock(fh,fcntl.LOCK_EX|fcntl.LOCK_NB)
    except:
        os._exit(1)

def run_this():
    mypid=str(os.getpid())
    myname=os.path.basename(__file__)
    while True:
        _cmd="ps -ef | grep "+myname+" | awk '{print $2}' | head -1"
        pid=subprocess.check_output(_cmd, shell=True)
        if pid!='' and pid!=mypid:
            _cmd="/usr/bin/kill -9 "+pid
            _cmd = shlex.split(_cmd)
            subprocess.check_output(_cmd, shell=False)
            logger.warning("This killed")
        else:
            break

def getTime():
    return time.strftime('%Y-%m-%d %H:%M:%S')

class getRedisServer():

   def __init__(
        self,
        ip,
        passwd,
        timeout,
        ):

        from redis.sentinel import Sentinel

        self.status=False
        self.redisWrite=None
        self.redisRead=None
        begin=time.time()
        while True:
            if self.redisWrite is None:
                #self.server = redis.Redis(host=ip, port=port, password=passwd, db=0, socket_connect_timeout=1.0)
                sentinel = Sentinel(ip, socket_timeout=0.1)
                try:
                    self.redisWrite=sentinel.master_for('neonmaster', socket_timeout=30, password=passwd)
                    self.redisRead=sentinel.slave_for('neonmaster', socket_timeout=30, password=passwd)
                except (redis.exceptions.ConnectionError):
                    logger.error("Redis exception")
                if self.redisWrite is not None:
                    if self.redisRead is None: self.redisRead=self.redisWrite
                    self.status = True
                    logger.info("Redis connected")
                    break
                else:
                    logger.error("Redis falied")
                if time.time()-begin>timeout:
                    logger.warning("Reids timeout")
                    break

   def getStatus(self):
        return self.status

   def getRedisWrite(self):
        return self.redisWrite

   def getRedisRead(self):
        return self.redisRead

class getEpicsServer():
    def __init__(
        self,
        retry,
        ):
        epics.ca.use_initial_context()

        pvCommand = "EXP_IB1_GP:soft:cmd"
        pvStatus = "EXP_IB1_GP:soft:online_stat"

        self.status=False

        self.epicsCommand = None
        self.epicsStatus = None
        
        for i in range(int(retry)):
            if not self.epicsCommand:
                try:
                    self.epicsCommand = epics.PV(pvCommand)
                    self.epicsStatus = epics.PV(pvStatus)
                    self.status=True
                    logger.info("EPICS connected")
                    break
                except:
                    logger.warning("EPICS retry")
            time.sleep(0.2)

    def getStatus(self):
        return self.status

    def getServer(self):
        return self.epicsCommand, self.epicsStatus

class getDroneServer():
    def __init__(self, droneInfo):
        import neon

        self.droneInfo=droneInfo
        self.nModule=len(self.droneInfo)

        self.m_neonRedis = neon.Neon.NeonRedisSentinel([('10.1.33.141', 9001),('10.1.33.145', 9001)], i_socket_timeout=0.1, \
                                                           master_name='neonmaster', master_timeout = 200, master_password='sanlie;123', \
                                                           idb = 0, isWritable = True)
        self.createAll()

    def create(self, n):
        clitpob= neon.Neon.NeonService.POBox(self.m_neonRedis, '/GPPD/process/detector', self.droneInfo[n]['host']+':client:'+self.droneInfo[n]['module'])
        clitrpc = neon.Neon.NeonService.NeonRPC(sendPOBox = clitpob, recvPOBox = clitpob)
        self.droneInfo[n]['pobox']=clitrpc
        self.droneInfo[n]['rpc']=self.droneInfo[n]['host']+':server:'+self.droneInfo[n]['module']
        _pid=self.getPid(n)

        if _pid == -1:
            while True:
                _cmd="ssh drone@"+self.droneInfo[n]['host']+" cd /home/drone/workspace/drone/cockpit/ && ./"+self.droneInfo[n]['module']
                _cmd = shlex.split(_cmd)
                subprocess.Popen(_cmd, shell=False)
                time.sleep(1.0)
                _pid=self.getPid(n)
                if _pid !=-1:
                    self.droneInfo[n]['running']='1'
                    self.droneInfo[n]['pid']=_pid
                    break
        else:
            self.droneInfo[n]['running']='1'
            self.droneInfo[n]['pid']=_pid

    def createAll(self):
        for i in range(self.nModule):
            self.create(i)

    def kill(self, n):
        while True:
            _pid=self.getPid(n)            
            if _pid!=-1:
                _cmd="ssh drone@"+self.droneInfo[n]['host']+" /usr/bin/kill -9 "+str(_pid)
                _cmd = shlex.split(_cmd)
                subprocess.check_output(_cmd, shell=False)
                #logger.info("The module killed, %s" % self.droneInfo[n]['module'])
            else:
                #logger.warning("The module no exist, %s" % self.droneInfo[n]['module'])
                break

    def killAll(self):
        for i in range(self.nModule):
            self.kill(i)

    def isExist(self, _droneInfo):
        exist=False
        _cmd="ssh drone@"+_droneInfo['host']+" ps -ef | grep "+_droneInfo['module']+".py | awk '{print $2}' | head -1"
        pid=subprocess.check_output(_cmd, shell=True)
        if pid!='':
            _cmd="ssh drone@"+_droneInfo['host']+" /usr/bin/kill -9 "+pid
            _cmd = shlex.split(_cmd)
            exist=True
            logger.info("The module exist, %s : %s" % (_droneInfo['module'], pid))
        else:
            exist=False
            logger.info("The module not exist, %s" % _droneInfo['module'])
        return exist

    def getPid(self, n):
        _cmd="ssh drone@"+self.droneInfo[n]['host']+" ps -ef | grep "+self.droneInfo[n]['module']+".py | awk '{print $2}' | head -1"
        print _cmd
        pid=subprocess.check_output(_cmd, shell=True)
        if pid!='':
            pid=int(pid)
        else:
            pid = -1
        return pid

    def getPidAll(self):
        for i in range(self.nModule):
            print self.droneInfo[i]['module'], self.getPid(i)
        
    def start(self, n):
        #_droneInfo['pobox'].execRPC(_droneInfo['rpc'], 'Start', {'string':'start', 'times':3}, 'Print', -1.0)
        self.clear(n)

    def startAll(self):
        for i in range(self.nModule):
            self.start(i)

    def configure(self, n):
        pass

    def configureAll(self):
        pass

    def stop(self, n):
        self.clear(n)

    def stopAll(self):
        for i in range(self.nModule):
            self.stop(n)

    def abort(self, n):
        self.clear(n)

    def abortAll(self):
        for i in range(self.nModule):
            self.abort(i)

    def clear(self, n):
        try:
            self.droneInfo[n]['pobox'].execRPC(self.droneInfo[n]['rpc'], 'Clear', {'string':'clear', 'times':3}, 'Print', -1.0)
        except:
            self.kill(n)
            time.sleep(1.0)
            self.create(n)
        #relist =  _droneInfo['pobox'].getRSLT()
        #for item in relist:

    def clearAll(self):
        for i in range(self.nModule):
            self.clear(i)

    def exit(self):
        self.killAll()

class setHeartbeat(threading.Thread):

    def __init__(
        self,
        refreshtime,
        ):
        threading.Thread.__init__(self)
        pvHeart = "EXP_IB1_RM:soft:analyse_hb"
        self.pvname=epics.PV(pvHeart)
        self.refreshtime=refreshtime


    def setStatus(self, _status):
        self.status=_status

    def getStatus(self):
        return self.status

    def process(self):
        self.pvname.put(getTime(), use_complete=True)

    def run(self):
        while True:
            try:
                self.process()
            except:
                pass
            time.sleep(self.refreshtime)

class setStatus(threading.Thread):

   def __init__(
        self,
        pvname,
        refreshtime,
        ):
        threading.Thread.__init__(self)

        self.status='WAITING'
        self.pvname=epics.PV(pvname)
        self.refreshtime=refreshtime

   def setStatus(self, _status):
        self.status=_status

   def getStatus(self):
        return self.status

   def process(self):
        self.pvname.put(self.getStatus(), use_complete=True)

   def run(self):
        while True:
            try:
                self.process()
            except:
                pass
            time.sleep(self.refreshtime)

class getEpicsCommand(threading.Thread):
    def __init__(self, redisServer, epicsStatus, droneServer):
        threading.Thread.__init__(self)
        epics.ca.use_initial_context()

        self.redisServer = redisServer
        self.epicsStatus = epicsStatus
        self.droneServer = droneServer

        self.pvCommand=epics.PV('EXP_IB1_GP:soft:cmd')
        self.redisPath="/GPPD/control/command"
        
        self.GPPDstatusList=['INITIALIZED', 'READY', 'RUNNING']
        self.GPPDcommandList=["CONF", "START", "STOP", "EXIT", "CANCEL"]
        self.MYstatusList=["waiting", "unconfigured", "configuring", "ready", "running", "paused", "error"]
        self.MYcommandList=["configure", "unconfigure", "start", "pause", "resume", "stop", "abort"]

        self.mantidHeartBeat='/GPPD/heartbeat/mantid'
        self.pilotHeartBeat='/GPPD/heartbeat/pilot'

        logger.debug("Initializing...")
        self.setTOF()
        try:
            self.getEpicsConfigure()
        except:
            pass
        logger.debug("Initialized!!!")
        
        self.lastTime="-"
        self.thisTime="-"

        self.setCommand(6, 1, 0, -1)

    def setCommand(self, cmd, stat, epics, retry):
        success=False

        cmd=int(cmd)
        stat=int(stat)
        epics=int(epics)
        retry=int(retry)
        if epics!=-1: _status=self.GPPDstatusList[epics]
        self.redisServer.set("/GPPD/control/command", json.dumps(cmd))

        _count=-1
        while True:
            if retry!=-1:
                _count+=1
                if _count > retry:
                    success=False
                    break

            mantidStatus = self.getMantidStatus()
            pilotStatus = self.getPilotStatus()
            if pilotStatus==stat and mantidStatus==stat:
                logger.debug("pilot & mantid, %s" % self.MYstatusList[pilotStatus])
                if epics!=-1:
                    self.epicsStatus.put(_status)
                    logger.debug("Tell epics, %s" % self.GPPDstatusList[epics])
                
                success=True
                break
            else:
                logger.debug("   Waiting for, %s" % self.MYstatusList[stat])
                logger.debug("   pilot,  %s" % self.MYstatusList[pilotStatus])
                logger.debug("   mantid, %s" % self.MYstatusList[mantidStatus])
            time.sleep(0.5)

        return success

    def getDroneStatus(self):
        droneStatus=4
        _statusList=[]
        try:
            for i in range(GPPDdroneInfo):
                _status = self.redisServer.get(self.droneHeartBeat)
                _statusList.append(json.load(_status)['status'])
            for i in range(GPPDdroneInfo-1):
                if _statusList[i+1]!=_statusList[i]:
                    droneStatus=6
                    break
        except:
            droneStatus=6
        return droneStatus

    def getMantidStatus(self):
        try:
            mantidStatus = self.redisServer.get(self.mantidHeartBeat)
            mantidStatus=json.loads(mantidStatus)['status']
        except:
            mantidStatus=0

        return mantidStatus

    def getPilotStatus(self):
        try:
            pilotStatus = self.redisServer.get(self.pilotHeartBeat)
            pilotStatus=json.loads(pilotStatus)['status']
        except:
            pilotStatus=0

        return pilotStatus

    def setTOF(self):
        _tmin=4000
        _tmax=40000
        _bin=100.0
        ntof=int((_tmax-_tmin)/_bin)
        self.tofmantid=np.zeros(ntof+1)
        for i in range(ntof+1):
            self.tofmantid[i]=int(_tmin+(i-1)*_bin-0.5*_bin)

        #_json=jsonArray.jsonEncoder(self.tofmantid.tolist())
        #self.redisServer.set("/GPPD/workspace/detector/module01/tof", _json)

    def getEpicsConfigure(self):
        try:
            run_no=int(epics.caget('EXP_IB1_GP:soft:run_no'))
        except:
            run_no="unknown"

        try:
            user_id=epics.caget('EXP_IB1_GP:soft:user_id')
        except:
            user_id="unknown"

        try:
            proposal_id=epics.caget('EXP_IB1_GP:soft:proposal_id')
        except:
            proposal_id="unknown"

        _configure={}
        _configure['runNo']=run_no
        _configure['userID']=user_id
        _configure['proposalID']=proposal_id
        _configure['tof']=self.tofmantid.tolist()
        _configure=json.dumps(_configure, ensure_ascii=False)
        self.redisServer.set("/GPPD/control/configure", _configure)
        logger.info("Set configure, %d" % run_no)

    def run(self):
        while True:
            mantidStatus = self.getMantidStatus()
            pilotStatus = self.getPilotStatus()
            if pilotStatus==6:
                logger.error("pilot failed")
                self.epicsStatus.put("ERROR")
                continue
            elif mantidStatus==6:
                logger.error("mantid failed")
                self.epicsStatus.put("ERROR")
                continue
            else:
                pass

            try:
                self.thisTime=self.pvCommand.timestamp
            except:
                continue

            if self.lastTime==self.thisTime:
                continue
            else:
                char_value=self.pvCommand.char_value
                self.lastTime=self.thisTime
            
            char_value=int(char_value)
            logger.info("Receive command %d" % char_value)
            
            if char_value == 0:#CONF
                self.getEpicsConfigure()
                time.sleep(0.5)
                _success=self.setCommand(0, 3, 1, 100)
                if not _success:
                    self.setCommand(6, 1, -1, -1)
                    self.setCommand(0, 3, 1, 100)

            elif char_value == 1:#START
                _success = self.setCommand(2, 4, 2, 100)

                if not _success:
                    #abort
                    self.setCommand(6, 1, -1, -1)
                    #conf
                    self.getEpicsConfigure()
                    time.sleep(0.2)
                    self.setCommand(0, 3, -1, 100)
                    #start
                    self.setCommand(2, 4, 2, 100)

                # clear drone
                try:
                    self.droneServer.clearAll()
                    logger.info("Drone cleared")
                except:
                    logger.error("Drone clear failed")


            elif char_value == 2:#STOP
                #stop
                _success = self.setCommand(5, 3, 0, 100)
                if not _success:
                    #abort
                    self.setCommand(6, 1, -1, -1)
                    #conf
                    self.getEpicsConfigure()
                    time.sleep(0.2)
                    self.setCommand(0, 3, 0, 100)
            elif char_value == 3 or char_value == 4:#EXIT or CANCEL
                #abort
                self.setCommand(6, 1, -1, -1)

            else:
                logger.warning("Invalid command %d" % char_value)

            time.sleep(0.5)

if __name__=="__main__":

    logger.info("===================")
    logger.info("Welcome to CockPit!")
    logger.info("        GPPD       ")
    logger.info("===================")
    #"==================="
    # connect Redis
    try:
        #myredis=getRedisServer("10.1.33.141", 9000, 10)
        myredis=getRedisServer([('10.1.33.141', 9001), ('10.1.33.145',9001)], "sanlie;123", 10)
        if myredis.getStatus():
            redisServer=myredis.getRedisWrite()
            logger.info("Redis Connected")
    except:
        redisServer=None
        logger.error("Redis not available")
    #"==================="
    # connect Epics
    try:
        myepics=getEpicsServer(10)
        epicsCommand, epicsStatus = myepics.getServer()
        logger.info("EPICS Connected")
    except:
        epicsCommand=None
        epicsStatus=None
        logger.error("EPICS Failed")

    try:
        _cmd=int(epicsCommand.get())
        if _cmd < 0 or _cmd>5:
            redisServer.set("/GPPD/control/command", json.dumps(-1))
    except:
        pass

    #"==================="
    # connect Drone
    try:
        droneServer=getDroneServer(GPPDdroneInfo)
        logger.info("Drone Created")
    except:
        logger.error("Drone Failed")
    #"==================="
    try:
        threadGetEpics = getEpicsCommand(redisServer, epicsStatus, droneServer)
        threadGetEpics.setDaemon(True)
        threadGetEpics.start()
        logger.debug("Command thread created")
    except:
        logger.error("Command thread Failed")
    time.sleep(0.1)

    try:
        threadGetEpics.join()
    except:
        pass

    #"==================="
    try:
        epicsStatus.put('ERROR')
        logger.info("GPPDcockpit quit")
    except:
        pass
