#!/usr/bin/python
# -*- coding: utf-8 -*-

import subprocess
import os
import sys


# sudo fuser -k 9000/tcp
# sudo kill -9 9000
# sudo killall -9 redis-server

def get_pid(name):
    PID = []
    try:

        # PID=map(int,subprocess.check_output(["pidof", name]).split())

        PID = map(int, subprocess.check_output(['pgrep', '-f',
                  name]).split())
    except:
        pass

    return PID


def kill_PID(name):
    p = subprocess.Popen(['ps', '-A'], stdout=subprocess.PIPE)
    (out, err) = p.communicate()

    for line in out.splitlines():
        if 'redis-server' in line:
            pid = int(line.split(None, 1)[0])
            print pid
            subprocess.Popen(['kill', '-9', str(pid)],
                             stdout=subprocess.PIPE,
                             stderr=subprocess.PIPE)


            # os.kill(pid, subprocess.signal.SIGKILL)

def kill_process(name):
    p = 'pkill -9 ' + name
    process = subprocess.call(p, shell=True)


    # process.communicate()

def redis_stop():
    name = 'redis-server'
    kill_process(name)
    name = 'redis-sentinel'
    kill_process(name)

    print 'INFO: Redis stopped!'


def redis_start():
    r = []
    r.append('/opt/shared/library/redis-4.0.1/bin/redis-server /home/neon/workspace/redis/master/redis_9000.conf'
             )
    r.append('/opt/shared/library/redis-4.0.1/bin/redis-sentinel /home/neon/workspace/redis/master/sentinel_9001.conf'
             )
    for p in r:
        subprocess.call(p, shell=True)

    r = []
    r.append('/opt/shared/library/redis-4.0.1/bin/redis-server')
    r.append('/opt/shared/library/redis-4.0.1/bin/redis-sentinel')
    for p in r:
        print get_pid(p)

    print 'INFO: Redis started!'


def redis_restart():
    redis_stop()
    redis_start()


if __name__ == '__main__':
    cmd = sys.argv[1]
    if cmd == 'start':
        redis_start()
    elif cmd == 'stop':
        redis_stop()
    elif cmd == 'restart':
        redis_restart()
    else:
        print 'start/stop/restart?'

