#!/usr/bin/python
# -*- coding: utf-8 -*-

# author: H.L. TIAN 2017

# import Sniper

import DroNECore
import DroNECore.PyIncident as PI
import CtrlSvc.PushMatrixIncident as PMI
import CtrlSvc.PushHistIncident as PHI
import CtrlSvc.HeartBeatIncident as HBI
import CtrlSvc.NeonRPCIncident as NRI
import CtrlSvc.NeonRPCTask as NRT
import CtrlSvc.NeonUpdateDataTask as NUT
import redis
import json
import os
import NEON


class RedisRemoteData:

    def __init__(self, ip, path):

        # import redis

        from redis.sentinel import Sentinel
        sentinel = Sentinel(ip, socket_timeout=0.1)
        self.server = sentinel.master_for('neonmaster',
                socket_timeout=200, password='sanlie;123', db=0)
        self.path = path

    def setData(self, data):
        self.data = data

    def dump(self):
        self.server.set(self.path, self.data)

    def getData(self):
        return self.data

    def load(self):
        self.data = self.server.get(self.path)


def App(in_module='', in_redisip='', in_cron=1):

    m_modulename = in_module  # 'module131'
    m_redisip = in_redisip  # '10.1.33.141'
    m_cron = in_cron  # 15

    from xml.etree import ElementTree as ET
    root = ET.parse('configure.xml')
    tof = root.find('tofInformation')
    factor = 40  # 25ns to 1us
    m_tofstart = int(tof.attrib['tofstart']) * factor
    m_tofstep = int(tof.attrib['tofstep']) * factor
    m_tofbins = int(tof.attrib['tofbin'])

    for item in root.findall('type/component'):
        if m_modulename == item.attrib['name']:
            m_moduleinfo = item.attrib

    path = '/GPPD/workspace/detector/' + m_modulename
    m_taskMatrix = RedisRemoteData(m_redisip, path + '/value')
    m_taskTOF = RedisRemoteData(m_redisip, path + '/tof')
    m_taskPID = RedisRemoteData(m_redisip, path + '/pid')
    toflist = [m_tofstep + i * m_tofstep for i in xrange(m_tofbins + 1)]
    m_taskTOF.setData(json.dumps(toflist))
    m_taskTOF.dump()

    m_taskheartbeat = RedisRemoteData(m_redisip,
            '/GPPD/heartbeat/detector/' + m_modulename)
    m_taskheartbeat.setData(HBI.HeartBeatCronIncident.encodeHeartBeat(status='configuring'
                            , hit=0, event=0, pulse=0, idx=os.getpid()))
    m_taskheartbeat.dump()

    idstart = int(m_moduleinfo['idstart'])
    idsize = int(m_moduleinfo['pixels'])
    pidlist = [i + idstart for i in xrange(idsize)]
    m_taskPID.setData(json.dumps(pidlist))
    m_taskPID.dump()

    m_configure = {'pidstart': idstart, 'pidsize': idsize}
    task = DroNECore.DroNEOnline('task')
    task.asTop()
    task.setLogLevel(2)

    # ===============

    m_neonRedis = NEON.Neon.NeonRedisSentinel(  # server mode, set msgs to Redis
        m_redisip,
        i_socket_timeout=0.1,
        master_name='neonmaster',
        master_timeout=200,
        master_password='sanlie;123',
        idb=0,
        isWritable=True,
        )
    servpob = NEON.Neon.NeonService.POBox(m_neonRedis,
            '/GPPD/process/detector', 'server:' + m_modulename)
    servrpc = NEON.Neon.NeonService.NeonRPC(sendPOBox=servpob,
            recvPOBox=servpob, isServer=True)
    nr = NRT.NeonRPCTask('NeonRPC', servrpc, remotedata=m_taskheartbeat)

    import CtrlSvc
    ct = DroNECore.CtrlTask('ctrl')
    pi = PMI.PushMatrixCronIncident('PushMatrix', cron=m_cron,
                                    repeatable=True,
                                    remotedata=m_taskMatrix,
                                    configure=m_configure)
    hi = HBI.HeartBeatCronIncident('HeartBeat', cron=2,
                                   repeatable=True,
                                   remotedata=m_taskheartbeat)
    ni = NRI.NeonRPCCronIncident('NeonRPC', cron=1, repeatable=True)
    ct.add(hi)
    ct.add(ni)
    ct.add(pi)

    # # ===========================

    nu = NUT.NeonUpdateDataTask('UpdateRemoteData',
                                remotedata=m_taskMatrix,
                                configure=m_configure)

    # # ===========================

    import DataSvc
    task.property('svcs').append('GPPDDataSvc/DataSvc')
    task.property('svcs').append('CtrlSvc')
    task.property('svcs').append('RawDataInputSvc/DataInputSvc')

    # task.property("svcs").append("FileInputSvc/DataProvideSvc")

    task.property('svcs').append('DimRecvSvc/DataProvideSvc')
    iDat = task.find('DataSvc')
    iSvc = task.find('DataInputSvc')
    iPvd = task.find('DataProvideSvc')

    iPvd.property('DataSize').set(1000000)
    dimsrvname = 'dimserver' + m_moduleinfo['server'] + '/TEST_SWAP_' \
        + m_moduleinfo['num']
    iPvd.property('DimServerName').set(dimsrvname)
    iSvc.property('BuffSize').set(1000000)

    iSvc.show()
    iPvd.show()

    import Algorithms
    task.property('algs').append('GPPDSNDRecAlg')
    task.property('algs').append('GPPDSNDMapAlg')
    task.property('algs').append('RunningInfAlg')

    # task.property("algs").append("DumpAlg")

    iRun = task.find('RunningInfAlg')
    iRun.property('TofStart').set(m_tofstart)
    iRun.property('TofBins').set(m_tofbins)
    iRun.property('TofStep').set(m_tofstep)
    iMap = task.find('GPPDSNDMapAlg')
    iMap.property('ConfigFileName').set('configure.xml')

    #

    task.setEvtMax(-1)
    task.run()


if __name__ == '__main__':
    App(in_module='module331', in_redisip=[('10.1.33.141', 9001)],
        in_cron=10)
