#include <iostream>
#include <stdio.h>
#include <vector>
#include <string>
#include <fstream>
#include <chrono>
#include "RedisNumpy.hh"

int
main(void) {

  RedisNumpy nvt;

  std::vector<double> data;
  unsigned sz = 100000000;
  data.reserve(sz);
  for(unsigned i=0;i<sz;i++)
    data.push_back(i);

  auto start = std::chrono::system_clock::now();
  unsigned loopnum = 100;
  double tot_time = 0.;
  std::string nparr;
  // for(unsigned i=0;i<loopnum;i++)
  {
    nvt.makeNumpyArr(data, RedisNumpy::data_type::f8,
                     std::vector<uint64_t>{data.size()/200,200},nparr);

    auto now = std::chrono::system_clock::now();
    std::chrono::duration<double> elapsed_seconds = now - start;
    tot_time += elapsed_seconds.count();
    start = now;
  }
  std::cout << "C++ array to numpy array conversion, average speed "
   << data.size()*sizeof(uint32_t)/1024./1024/(tot_time/loopnum) << " MB/seconds" <<std::endl;

  std::ofstream outfile("double4.npy", std::ofstream::trunc|std::ofstream::binary);
  outfile << nparr;
  outfile.close();


  return 0;
}
