#ifndef Action_MR_hh
#define Action_MR_hh

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "RedisNumpy.hh"
#include "MyStateMachine.hh"

class Action_MR {
public:
	Action_MR(const std::shared_ptr<RedisIO> &redis,const std::shared_ptr<Hist2DMap> &histmap,
		 const std::shared_ptr<MyStateMachine> &sMachine);
	virtual ~Action_MR();

  bool breakLoop();

	bool configure();
	//Stop running and clear any runtime determined parameter
  bool unconfigure();
  //Start accumulate data, RESET AGAIN HERE
	bool start();
	//Paused fill histogram, still receive but unprocess dim datastream
	bool pauseStop();
  //Back to unconfigure state
	bool abort();
  //Restart running;
	bool resume();
  //received kill command. Set m_kill so breakLoop can break external loops
	bool kill();
	bool keepRunning();

private:
	bool m_kill;
	Hist2DMap::DetectorType m_detType;
	std::shared_ptr<RedisIO> m_redis;
	std::shared_ptr<Hist2DMap> m_histmap;
	std::shared_ptr<MyStateMachine> m_sMachine;
	std::shared_ptr<DAQInterface> m_daq;
  nlohmann::json m_allPath;
	std::chrono::time_point<std::chrono::steady_clock>  m_startTime;
};


#endif
