
#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include <nlohmann/json.hpp>

#include "Action_MR.hh"
#include "Earthworm.hh"


Action_MR::Action_MR(const std::shared_ptr<RedisIO> &redis,const std::shared_ptr<Hist2DMap> &histmap,
	 const std::shared_ptr<MyStateMachine> &sMachine)
: m_kill(false), m_detType(Hist2DMap::DetectorType::kUnknown),
  m_redis(std::shared_ptr<RedisIO> (redis)),
  m_histmap(std::shared_ptr<Hist2DMap> (histmap)),
	m_sMachine(std::shared_ptr<MyStateMachine> (sMachine)),
	m_daq(nullptr)
{

}

Action_MR::~Action_MR(){};

bool Action_MR::configure()
{
	//fixme: he3 only
	//fixme: update m_allPath fisrt !!!!!

	std::ifstream f("allPath.json");
	m_allPath.clear();
	f >> m_allPath;

	std::string conf = m_redis->readString(m_allPath["configure"]);//
	auto confjson =	nlohmann::json::parse(conf);


	std::string dt= confjson["mode"];

  m_daq.reset(new DAQInterface(m_allPath["dimserverHe3"],1000));

  m_daq->setActive(false);

	m_histmap->reset();
	m_daq->setHist2DMap(m_histmap);
	unsigned pid_num(300), tof_num(2500);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num*4;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num*4);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	m_redis->writeString(m_allPath["rawDataPixel"], pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	m_redis->writeString(m_allPath["rawDataTof"], tofstr);





	if(dt=="He3")
		 m_detType=Hist2DMap::DetectorType::kHe3;
	else if(dt=="MWPC")
		 m_detType=Hist2DMap::DetectorType::kMWPC;
	m_histmap->reset();

	EW_LOG_INFO("Configuration completed. Instrument active detector is {}.", dt);
	return true;
}

//Stop running and clear any runtime determined parameter
bool Action_MR::unconfigure()
{
	m_daq->setActive(false);
	m_detType = Hist2DMap::DetectorType::kUnknown;
	EW_LOG_INFO("Earthworm unconfigured.");
	return true;
}

//Start accumulate data, RESET AGAIN HERE
bool Action_MR::start()
{
	m_histmap->reset();
	m_daq->setActive(true);
	m_startTime = std::chrono::steady_clock::now();
	EW_LOG_INFO("Run started and reseted buffer.");
	return true;
}

//Paused fill histogram, still receive but unprocess dim datastream
bool Action_MR::pauseStop()
{
	m_daq->setActive(false);
	EW_LOG_INFO("kPause or kStop.");
	return true;
}

bool Action_MR::abort()
{
	m_daq->setActive(false);
	EW_LOG_INFO("abort.");
	return true;
}

//Restart running
bool Action_MR::resume()
{
	m_daq->setActive(true);
	EW_LOG_INFO("kResume.");
	return true;
}

bool Action_MR::kill()
{
	m_daq->setActive(false);
	m_kill=true;
	return true;
}

bool Action_MR::breakLoop()
{
	return m_kill;
}



bool Action_MR::keepRunning()
{
	std::string redisDataStr;
	m_histmap->makeNumpyRaw(redisDataStr);
	m_redis->writeString(m_allPath["rawDataHist"], redisDataStr);
	double totcnt = m_histmap->getIntegral();
	double cnt_rate=0.;
	if(totcnt)
		cnt_rate=totcnt/std::chrono::duration_cast<std::chrono::seconds>(std::chrono::steady_clock::now() - m_startTime).count();
	if(totcnt)
	EW_LOG_INFO("Data integral {}, rate is {} event/s", totcnt,
							cnt_rate);

	if( m_detType==Hist2DMap::DetectorType::kHe3)
	{
			m_redis->writeString(m_allPath["he3DetCnt"], std::to_string((int) m_histmap->getIntegral()) );
			m_redis->writeString(m_allPath["he3DetCntRate"], std::to_string(cnt_rate) );
	}
	else if( m_detType==Hist2DMap::DetectorType::kMWPC)
	{
			m_redis->writeString(m_allPath["mwpcDetCnt"],std::to_string((int) m_histmap->getIntegral())+"}");
  }
	else
		EW_LOG_CRITICAL("Detector type is unconfigured!");

	return true;
}
