#!/usr/bin/python

from xlib.NeutronScatteringLaw import NeutronScatteringLaw as sclaw
from xlib.helper import *
import xlib.constants as const
import numpy as np
import matplotlib.pyplot as plt


#light
h_incoxs=80.27
h_colen = 0.37406
law=sclaw('ana/localFullH2O.h5', 0.0253, 1 ,2)

##heavy
#h_incoxs=2.05
#h_colen = 0.6671
#law=sclaw('ana/localFullD2O.h5', 0.0253, 1 ,2)

o_incoxs=0.0008
o_colen = 0.5803


#qtq = law.quantumFtq('hh',0.55, 1)


#keys = law.keys()
keys=['hdh', 'hh', 'ho', 'oo']


for k in keys:
    vdos=law.getDos(k, 0.5)
    x=np.linspace(0,vdos.fre.max(),100)
    plt.plot(x*const.const_radpsec2meV, vdos.getDensity(x)/const.const_radpsec2meV, label=k)

plt.xlabel('freq, meV')
plt.ylabel('dos, meV^-1')
plt.legend()
plt.show()

#############################

ftq_hdh, tfs, Q = law.quantumFtq('hdh',0.5)
ftq_hh, tfs, Q = law.quantumFtq('hh',0.5)
ftq_ho, tfs, Q = law.quantumFtq('ho',0.5)
ftq_oo, tfs, Q = law.quantumFtq('oo',0.5)

ftq = ftq_hdh*2.*h_colen*h_colen
ftq += ftq_hh*4.*h_colen*h_colen
ftq += ftq_ho*4.*h_colen*o_colen
ftq += ftq_oo*o_colen*o_colen

ftq += ftq_hh*2*h_incoxs/(4*np.pi)
ftq += ftq_oo*o_incoxs/(4*np.pi)

swq , fre = real2realFFT(ftq,(tfs[1]-tfs[0])*1e-15/(2*np.pi), axis=0) #to angular frequncy, in rad*Hz
swq /= 2*np.pi*const.const_hbar
en  = fre*const.const_radpsec2meV

######
#swq_hdh, omega, Q = law.quantumSwq('hdh',0.5)
#swq_hh, omega, Q = law.quantumSwq('hh',0.5)
#swq_ho, omega, Q= law.quantumSwq('ho',0.5)
#swq_oo, omega, Q = law.quantumSwq('oo',0.5)
#
#swq = swq_hdh*2.*h_colen*h_colen*4*np.pi
#swq += swq_ho*4.*h_colen*o_colen*4*np.pi
#swq += swq_hh*4.*h_colen*h_colen*4*np.pi
#swq += swq_oo*o_colen*o_colen*4*np.pi
#
#swq += swq_hh*2*h_incoxs
#swq += swq_oo*2*o_incoxs
#en=omega*const.const_radpfs2meV

plt.figure()
for i in [30,100,150]:
    order = 10
    plt.semilogy(en, swq[:,i], label='Q='+str(Q[i]))

plt.legend()
#############################

def qmeV(theta, en, enscat): #move to helper
    ratio = enscat/en
    k0=np.sqrt(en/2.072124652399821)
    deg = np.pi/180.
    scale = np.sqrt(1.+ ratio - 2*np.cos(theta*deg) *np.sqrt(ratio) )
    return k0*scale

from scipy import interpolate
intSwq = interpolate.interp2d(en, Q, swq.T)

scatE =np.linspace(10., 450., 1000)
en0 = 250.
angledeg=25
cab7Q =  qmeV(angledeg, en0, scatE )

#plt.plot(scatE,cab7Q)


xs=[]
for cq, dltE in zip(cab7Q, scatE-en0):
    xs.append( intSwq(dltE, cq))
xs=np.array(xs)


plt.figure()
plt.semilogy(scatE*1e-3, xs*1e3*80.26*2) #in eV

####################################

en0=170.
scatE = np.linspace(0, 500, 300)
fact = np.sqrt(scatE/en0)
angle=np.linspace(2, 140., 1000)
angdist = np.zeros(angle.size)

for i in range(angle.size):
    xs=[]
    qlist =  qmeV(angle[i], en0, scatE )
    for cq, dltE in zip(qlist, scatE-en0):
        xs.append( intSwq(dltE, cq))
    xs=np.array(xs).flatten()
    angdist[i]=np.trapz(xs*fact,scatE)

plt.figure()
plt.plot(angle,angdist)
#plt.title('DO')
plt.show()
