import numpy as np
from constants import *

#default units:
#energy eV
#wavelength angstrom
#time second
#wavenumber angstrom^-1
#angle degree

def angularFre2eKin(fre):
    return fre*const_radpsec2eV

def eKin2AngularFre(en):
    return en*const_eV2radpsec

def eKin2k(eV):
    return np.sqrt(eV*const_eV2kk)

def q2Alpha(Q, kt):
    return Q*Q/(kt*const_eV2kk)

def alpha2Q(alpha,kt):
    return np.sqrt(alpha*kt*const_eV2kk)

def angle2Q(angle, enin_eV, enout_eV):
    ratio = enout_eV/enin_eV
    k0=eKin2k(enin_eV)
    scale = np.sqrt(1.+ ratio - 2*np.cos(angle*deg2rad) *np.sqrt(ratio) )
    return k0*scale

def angle2Alpha(angle, enin_eV, enout_eV, kt):
   return (enin_eV + enout_eV - 2*np.sqrt(enin_eV * enout_eV)*np.cos(angle*const_deg2rad))/kt

def real2realFFT( rawin, deltaT=1., axis=0):
    s = [slice(None)]*rawin.ndim
    s[axis] = slice(-1,0,-1)

    fftin = np.concatenate((rawin[tuple(s)].conjugate(),rawin),axis=axis)
    fftin = np.ascontiguousarray(fftin)

    s = [np.newaxis]*fftin.ndim
    s[axis] = slice(None)

    fftout = np.fft.fftshift(np.fft.fft(fftin,axis=axis),axes=axis)*deltaT
    fre=np.fft.fftshift(np.fft.fftfreq(fftout.shape[axis]))/deltaT

    fftSize=fftout.shape[axis]
    s = [slice(None)]*fftin.ndim
    s[axis] = slice(fftSize//4,fftSize//4*3,1)
    fftout=fftout[tuple(s)]

    fre = fre[fftSize//4:fftSize//4*3]

    # print('real',np.abs(fftout.real).sum(), 'imag', np.abs(fftout.imag).sum())
    return np.abs(fftout.real), fre
