#include <fstream>
#include <chrono>
#include <vector>
#include <cstdint>
#include <numeric>
#include <random>
#include <algorithm>
#include <iostream>
#include <cassert>
#include <dic.hxx>
#include <thread>

class DimGrabber: public DimClient {
public:
  DimGrabber(std::string daq_name="DAQ")
  :DimClient(),m_datasize(0)
  , m_daq_data(daq_name.c_str(),const_cast<char *>("dataAsCharArr"), this)
  {}
  virtual ~DimGrabber() {std::cout << "Exiting" << '\n';}
	//infoHandler treat newly received data
  void infoHandler() override
  {
    std::cout << "triggered" << '\n';
    DimInfo *curr = getInfo(); // get current DimInfo address
    if(curr == &m_daq_data)
    {
      //infohandler will be triggered by constructor in dim v20
      //when the buffer shouble empty
      unsigned dsize  = curr->getSize();
      uint8_t *data = static_cast<uint8_t*>(curr->getData());
      std::vector<uint8_t> buf(data, data+dsize);

      unsigned zeros = 0; //112 bit
      unsigned breakpoint = 0;
      for(unsigned i=0;i<dsize;i++)
      {
        if(data[i]==0)
          zeros++;
        else
          zeros=0;
        if(zeros > 112)
        {
          breakpoint=i;
          break;
        }
      }
      if(breakpoint)
      {
        auto myfile = std::fstream("mwpc" + std::to_string(curr->getTimestamp()) + "_" + std::to_string(curr->getTimestampMillisecs()) + ".bin", std::ios::out | std::ios::binary);
        myfile.write((char*)&buf[0], breakpoint);
        m_datasize += breakpoint;
        myfile.close();
      }
    }
  }
  unsigned m_datasize;
  DimStampedInfo m_daq_data;
};


int main()
{
  DimGrabber grabber("dimserver/TEST_SWAP_0");

  while (grabber.m_datasize<10*1024*1024) //10MB
  {
    std::this_thread::sleep_for(std::chrono::milliseconds(5000));
    std::time_t t = std::time(nullptr);
    char mbstr[100];
    if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
    }
    std::cout << "Received data size is " << grabber.m_datasize/1024./1024. << "MB at " << std::string(mbstr) << '\n';
  }

  return 0;
}
