#include "ParserMWPC.hh"
#include "UtilsException.hh"

Parser::ParserMWPC::ParserMWPC() { }
Parser::ParserMWPC::~ParserMWPC() { }

void Parser::ParserMWPC::readHeader(const uint8_t*& pt, MWPCHeader& header) const
{
  const uint8_t* end = nullptr;
//  if(findEnd(pt,end))
 //   printf("this is a valid package, size is 0x%x, %p, %p\n", end-pt, pt, end);
  uint32_t temp = 0;
  read_uint32 (pt,temp);
  error_assert(temp==MWPC_SIG);  //fixme: error handling


  header.instrment = *pt;
  header.detector_type = *(++pt);
  pt+=3;
  header.opt_mode = *(++pt);
  header.freq_div_mode = *(++pt);
  header.data_version = *(++pt);
  header.data_type = *(++pt);

  pt += 4*7;
  read_uint32(pt,header.t0cnt);
  read_uint32(pt,header.payload_bycnt);
  read_uint32(pt,header.map_num);

  // printf("""instr 0x%x, det type 0x%x, opt mode 0x%x, freq div 0x%x\n"""
  //        """ data ver 0x%x, data type 0x%x, t0 cnt %d, byte cnt 0x%x, map cnt %d\n""",
  //       header.instrment, header.detector_type, header.opt_mode, header.freq_div_mode,
  //       header.data_version, header.data_type,header.t0cnt , header.payload_bycnt, header.map_num);
  // printf("next byte 0x%x\n", *(pt+12));

  pt+=12; //12 bytes followed are reserved.
}

bool Parser::ParserMWPC::fixStartFindEnd(const uint8_t* const stream_pt, const uint8_t* const end, const uint8_t*& pkgend) const
{
  //match token
  const uint8_t *pt = stream_pt;
  if(*pt!=0xee && *(pt+1)!= 0x12 && *(pt+2)!= 0x34 && *(pt+3)!= 0xee)
    return false;

  uint32_t bycnt = 0;
  if(pt+44>=end)
    return false;

  pt +=44; //jump to the "byte count" position
  read_uint32 (pt, bycnt);
  if(pt + bycnt - 48>= end)
    return false;
  pkgend = pt + bycnt - 48;// read_uint32 moved pt forward by 48
  return true;
}
