#ifndef Parser_ParserMWPC_hh
#define Parser_ParserMWPC_hh

#include <stdint.h>
#include <vector>

#include "ParserBase.hh"

//This class reads segments of raw package from He3 detector.
namespace Parser {

  class EXPORT_SYMBOL ParserMWPC: public ParserBase {
  public:
    struct MWPCHeader {
      uint8_t instrment, detector_type, opt_mode, freq_div_mode, data_version, data_type;
      uint8_t model_status[6];
      uint32_t model_bycnt[6];
      uint32_t t0cnt, payload_bycnt,map_num;
    };



   enum MWPCFLAG: uint32_t {
     MWPC_HIT  = 0xAA,
     MWPC_SIG  = 0XEE1234EE
   };


  public:
    ParserMWPC();
    ~ParserMWPC() override;
    void readHeader(const uint8_t*& pt, MWPCHeader& header) const;
    void readHit();

    bool fixStartFindEnd(const uint8_t* const pt, const uint8_t* const end, const uint8_t*& pkgend) const override;

  private:

  };
}
#endif
