#include<iostream>
#include<string>
#include<vector>
#include<tinyxml.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <map>
#include "parseXML.h"
#include "parseNXS.h"
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <typeinfo>
#include <dirent.h>
#include <nlohmann/json.hpp>
using json = nlohmann::json;
using namespace std;

int dim[1]={0};
//const int XPID=92;
//const int YPID=50;
//const int XPID_M=32;
//const int YPID_M=32;

void SaveNexusFile(string prepath, string runno, string nxsfilename, string sumfilename, string ddffilename, json confJSON, const int dSize, string dName[])
{
    ParseXML ddfXML(ddffilename);
    cout<<"parseddf"<<endl;
    ParseNXS m_nxs(nxsfilename);
    NXaccess mode(NXACC_CREATE5);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfilename.c_str(), mode, &fileID);
    status=NXmakegroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"csns","NXentry");
    status=NXmakegroup(fileID,"histogram_data","NXcollection");
    status=NXopengroup(fileID,"histogram_data","NXcollection");
    NXclosegroup(fileID); //close histogram_data
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);

    ParseXML sumXML(sumfilename);
    cout<<"parsesum"<<endl;
    m_nxs.setPublic(sumXML,ddffilename);
    m_nxs.setInstrument(sumXML);

    //ParseXML confXML(conffilename);

    // m_nxs.setPresentData(10000,4);
    //m_nxs.setUser();
    //m_nxs.setProcess();
    //m_nxs.setLogs(sumXML);
    
    //m_nxs.setDetector(prepath, runno, sumXML, ddfXML, confJSON, dSize, dName, true);
    //const int dSize_m=3;
    //string dName_m[dSize_m] = {"monitor1", "monitor2", "monitor3"};
    //m_nxs.setDetector(prepath, runno, sumXML, ddfXML, 32, 32, time_start, 40001, 1, dSize_m, dName_m, false);
    //m_nxs.setDetector(prepath, runno, sumXML, ddfXML, confXML, dSize_m, dName_m, false);
    //m_nxs.setEventData(dName, dSize);
    //m_nxs.setHistData(dSize, dName);
    //m_nxs.setHistData(dSize_m, dName_m);
    
}

int main(int argc, char *argv[])
{
    if(argc<=1)
    {
        printf("Usage:%s runNumber prepath\n", argv[0]);
        return 0;
    }
    string runno=argv[1];
    //string detType=argv[1];
    //string prepath= argv[2];


    ifstream f("test.json");
    json confJSON;
    f >> confJSON;


    string prepath="/home/dur/BL02";
    string detType = "He3";
    bool dirExists(const string&);
    string filepath = to_string(confJSON.find("controlPath").value())+"/"+runno;
    //string filepath="/home/dur/BL02/Control/"+runno;
    string sumfile=""; 
    if(dirExists(filepath))
    {
        DIR *dirp;
        struct dirent *dp;
        dirp=opendir(filepath.c_str());
        while((dp = readdir(dirp))!=NULL)
        {
            string name = dp->d_name;
            int num=name.size();
            cout<<"opendir: "<<name<<endl;
            if((name.size()>4) && (name.substr(num-3,3)=="xml"))
            {    int iPos = name.find_last_of("-");
                string tmp= name.substr(iPos+1);
                iPos=tmp.find_last_of(".");
                tmp=tmp.substr(0,iPos);
                if(atoi(tmp.c_str())==atoi(runno.substr(3).c_str()))
                {
                    sumfile=filepath+"/"+name;
                    cout<<"sum file is: "<<sumfile<<endl;
                    break;
                }
            }
        }

    }else{;} 

        
        string nxsfile=prepath+"/"+runno+"/detector.nxs";
        string ddffile = to_string(confJSON.find("idfPath").value())+"/bank_"+detType+".xml";
        //string ddffile=prepath+"/paramData/detector_"+detType+".xml";
        //string conffile=prepath+"/test.json";
        const int dSize = 1;
        //const int dSize = 42;
        string dName[dSize]={"module1"};
        //string dName[dSize]={"module131"};
        SaveNexusFile(prepath, runno, nxsfile, sumfile, ddffile, confJSON, dSize, dName);    
        cout<<"finish save nexus"<<endl;
        string path = prepath+"/"+runno+"/complete.dat";
        std::ofstream markfile;
        markfile.open(path.c_str());
        markfile<<"completed"<<endl;
        markfile.close(); 

        return 0;
    }

