#!/usr/bin/python

from __future__ import print_function
import time
import sys
import h5py
import numpy as np
from xlib.Trajectory import Trajectory


radpsec2meV =  6.5821e-13
radpfs2meV = radpsec2meV*1e15

fname = 'dump_h5md.h5'
out = 'mdana.h5'
pairs = None
if len(sys.argv)==2:
    fname = sys.argv[1]
if len(sys.argv)==3:
    fname = sys.argv[1]
    out = sys.argv[2]

if len(sys.argv)==4:
    fname = sys.argv[1]
    out = sys.argv[2]
    pairs = np.uint(sys.argv[3])

trj = Trajectory(fname)


tasks = [['hdh',1,(1,1)],
        ['hh',1,1],
        ['oo',2,2],
        ['ho',1,2]]

f = h5py.File(out,'w')

maxTimeWindowFs = 20.e3
maxTimeStep =  maxTimeWindowFs/ trj.deltaTfs
nTimeStep = np.min([maxTimeStep, trj.nFrame//2])
timeStep=np.arange(0, nTimeStep, 1,dtype=np.uint32)
print('time window sizes are between', timeStep[0] , 'and',timeStep[-1])

Q=np.logspace(-1,2,300)

for atask in tasks:
    grp=f.create_group(atask[0])
    grp['deltaTfs'] = trj.deltaTfs
    grp['t'] = timeStep*trj.deltaTfs
    grp['Q'] = Q

    print('performing task',atask[0] )
    start_time = time.time()
    # #cvv = trj.cvv(atask[1],atask[2], pairs)
    cvv = trj.cvv(atask[1],atask[2], None)
    print  ('cvv elapsed ' , time.time() - start_time, 's')
    grp['cvv'] = cvv

    start_time = time.time()
    ftq=trj.intermediate( atask[1],atask[2],  Q, timeStep , pairs)
    print  ('intermediate elapsed ' , time.time() - start_time, 's')
    grp['ftq'] = ftq

    # start_time = time.time()
    # rSpacingInAa, tSpacingInfs, rScalefact, gtr = trj.gtr(atask[1],atask[2],15.,1000)
    # print  ('gtr elapsed ' , time.time() - start_time, 's')
    # grp['gtr'] = gtr
    # grp['rSpacingInAa'] = rSpacingInAa
    # grp['tSpacingInfs'] = tSpacingInfs
    # grp['rScalefact'] = rScalefact
    # print  ('time ' , time.time() - start_time, 's')

f.close()
