#include "FileSysHelper.hh"


FileReader::FileReader(std::string fname)
:m_source(fname, std::ifstream::ate|std::ios_base::binary)
{
  m_source.seekg (0, m_source.end);
  m_length = m_source.tellg();
  m_source.seekg (0, m_source.beg);
}

const size_t FileReader::fileLength() const
{
  return m_length;
}

FileReader::~FileReader()
{

}

void FileReader::readAll(std::vector<uint8_t> &data)
{
  auto ori = m_source.tellg();
  m_source.seekg (0, m_source.beg);
  data.reserve(m_length);
  m_source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(data.data())),m_length);
  m_source.seekg (ori); //restore 
}


const std::ifstream& FileReader::getStream()
{
  return m_source;
}
