// The Server publishes one service (integer value)
// and updates it from time to time (when it changes):
#include <iostream>
#include <vector>
#include <thread>
#include <chrono>
#include <time.h>
#include <dis.hxx>
#include <string>
#include <fstream>
#include "Earthworm.hh"

int main(int argc, char *argv[])
{
	double refreshtime =1.0;

	int interval = 200;
	if(argc==2)
	  interval = atoi(argv[1]);

	if(argc==3)
		refreshtime = atof(argv[2]);

  EW_LOG_INFO("Starting dim server shenme/shenme");
	EW_LOG_INFO("event interval {}ms ", interval);


	std::string fname = "pmt_benckmark.dat";
	std::ifstream source(fname, std::ifstream::ate | std::ios_base::binary);

	// get length of file
	source.seekg (0, source.end);
	int length = source.tellg();
	printf("data size is %gMB \n", length/1024./1024);

	source.seekg (0, source.beg);

	// allocate memory:
	const uint8_t * buffer = new uint8_t [length];

	// read data as a block:
	source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
	source.close();

  int run = 0;
  DimService charServ("shenme/shenme", ("C:"+std::to_string(length)).c_str(),
	                    reinterpret_cast<void*>(const_cast<uint8_t*>(buffer)), length );

  DimServer::start("SimGPPD");
	auto start = std::chrono::system_clock::now();
	long totsize =0;
  while(1)
  {
		std::this_thread::sleep_for(std::chrono::milliseconds(interval));
		// std::cout << "run " << run << std::endl;
		// sprintf(data,"%s %d","xx is vgl", run);
		charServ.updateService(reinterpret_cast<void*>(const_cast<uint8_t*>(buffer)), length );

		run++;
		totsize += length;

		std::chrono::duration<double> elapsed_seconds = std::chrono::system_clock::now()-start;
		double t = elapsed_seconds.count();
    if(t > refreshtime) //terminal update rate in second
		{
			std::cout << '\r'
	          << "Run " << run
						<< ". Elapsed " << t*1000.
						<< "ms. Rate: " <<  totsize/1024./1024/t
						<< "MB/s.\n";// << std::flush;
		  totsize =0 ;
			start = std::chrono::system_clock::now();
		}

  }
	delete []buffer;
}
