#include <vector>
#include <fstream>

uint64_t MASK_24 = 0XFFFFFF;
uint64_t MASK_8 = 0XFF;

void fillTime(std::vector<uint8_t>& data, unsigned tof_us)
{
  //convert to raw, mult by 40
  uint32_t tofraw = (tof_us*40)& MASK_24;
  data.push_back( (tofraw>>16) & MASK_8);
  data.push_back( (tofraw>>8) & MASK_8);
  data.push_back( tofraw & MASK_8);
}

int main(int argc, char *argv[])
{
  std::vector<uint8_t> data{0xfa, 0x01, 0x01, 0x2b, 0x09, 0x01, 0x03, 0x00, 0x00, 0x00, 0x00, 0xdc, 0xff, 0xff, 0xff, 0xff};

  // for(unsigned tof_us=0; tof_us<10000;tof_us+=100)
  {
    unsigned tof_us=1;
    for(unsigned x=1;x<101;x++)
    {
      for(unsigned y=1;y<61;y++)
      {
        data.push_back(x);
        fillTime(data, tof_us);
        data.push_back(y+128);
        fillTime(data, tof_us);
        tof_us += 10;
      }
    }
  }

  data.push_back(0xfb);
  for(unsigned i=0;i<7;i++)
    data.push_back(0);

  std::ofstream myFile ("pmt_benckmark.dat", std::ios::out | std::ios::binary);
    myFile.write (reinterpret_cast<const char*>(data.data()),data.size());
    myFile.close();
   return 0;
}
