#include "parserXML.h"
#include "parserNXS.h"
#include <limits>
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <vector>
#include <dirent.h>
#include <unistd.h>
#include <numeric>
#include "ParserUtils.hh"
#include "PackageHe3.hh"
#include "PackageHe3PosCorr.hh"
#include "NumpyHist1D.hh"
#include "NumpyHist2D.hh"


using namespace std;


void ParserNXS::coutMap(map<string, string> info)
{
    for(auto it = info.begin(); it!=info.end(); it++)
        cout<<it->first<<"||"<<it->second<<endl;
}

string ParserNXS::int2string(int num)
{
    stringstream ss;
    ss<<num;
    string tmp = ss.str();
    return tmp;
}

bool ParserNXS::judgeMap(map<string, string> data)
{
    auto it = data.begin();
    if(it==data.end() || (it->first)=="None")
    {    return false;
    }else{
        return true;
    }
}

bool ParserNXS::judgeVector(const vector<map<string, string> > &data)
{
    auto it = data.begin();
    if(it==data.end())
    {    return false;
    }else{
        map<string, string> tmp = *it;
        auto it2 = tmp.begin();
        if(it2->first == "None")
        {return false;
        }else{
        return true;}
    }
}

string ParserNXS::getStringFromMap(const map<string, string> data, string name)
{
    string tmp="";
    auto it = data.find(name);
    if(it!= data.end())
    {    tmp = it->second;
    }else{
         tmp = "None";}
    return tmp;
}
float ParserNXS::getFloatFromMap(const map<string, string> data, string name)
{
    auto it = data.find(name);
    float tmp = 0.0;
    if(it!= data.end())
        tmp = atof(it->second.c_str());
    return tmp;
}
int ParserNXS::getIntFromMap(const map<string, string> data, string name)
{
    auto it = data.find(name);
    int tmp = 0;
    if(it!= data.end())
        tmp = atoi(it->second.c_str());
    return tmp;
}
map<string, string> ParserNXS::getMapFromVector(const vector<map<string, string> >& data, string keyword, string value)
{
    map<string, string> tmp;
    for(auto it=data.begin(); it!=data.end(); it++)
    {
        string str1 = getStringFromMap(*it, keyword);
        if(0==strcmp(str1.c_str(), value.c_str()))
            tmp=*it;
    }
    return tmp;
}

vector<string> ParserNXS::split(string str, string sep)
{
   char* cstr=const_cast<char*>(str.c_str());
    char* current;
    std::vector<std::string> arr;
    current=strtok(cstr,sep.c_str());
    while(current!=NULL){
        arr.push_back(current);
        current=strtok(NULL,sep.c_str());
    }
    return arr;
}

/*
void ParserNXS::getMRData(string daqFile, const int pidNum, const int pidStart, const int pidEnd,  const int tofNum, const int tofStart, const int tofEnd, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData)
{

    NumpyHist2D hist2(pidNum, pidStart, pidEnd, tofNum, tofStart, tofEnd);
    uint32_t n = 0;            
    std::ifstream source(daqFile, std::ifstream::ate|std::ios_base::binary);
    source.seekg (0, source.end);
    int length = source.tellg();
    source.seekg (0, source.beg);
    const uint8_t * buffer = new uint8_t [length];
    source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
    source.close();
    
    auto *he3 = new Parser::PackageHe3(0.);
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;

    const uint8_t * abuf = buffer;
    std::map<uint32_t, uint32_t> mapfile;
    mapfile.insert(make_pair(7,1));
    mapfile.insert(make_pair(8,2));
    mapfile.insert(make_pair(9,3));
    mapfile.insert(make_pair(11,4));
    uint32_t tmp=0;
    uint32_t m_bins = 300;
    while(he3->readNextPackage(abuf, buffer+length, hitinfo))
    {
        event_cnt+=hitinfo.size();
        for(auto v: hitinfo)
        {
            tmp = mapfile[v.id];
            int pixelID = 100001+m_bins*(tmp-1)+int(v.pos);
            pid.push_back(pixelID);
            tof.push_back(v.t);
            pulse.push_back(v.hit_t0);
            hist2.fill(pixelID, v.t);
            n++;
        }
    }

    evtNum = n-1;
    cout<<"evt num: "<<evtNum<<endl;
    auto tmp2 = hist2.getRaw();
    for(unsigned i=0;i<tmp2.size();i++)
        histData.push_back(tmp2[i]);

}
*/
void ParserNXS::getSANSData(const vector<string> &daqFile, const int pidNum, const int pidStart,  const int tofNum, const int tofStart, const int tofEnd, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse, std::vector<uint32_t> &histData, float lowerValue, float upperValue, int bins)

{
   int pidEnd = pidStart+pidNum; 
    cout<<pidStart<<"||"<<pidEnd<<"||"<<pidNum<<endl;
    cout<<tofStart<<"||"<<tofEnd<<"||"<<tofNum<<endl;
    //NumpyHist2D hist2(pidNum, pidStart, pidEnd, tofNum, tofStart, tofEnd);
    NumpyHist2D hist2(tofNum, tofStart, tofEnd,pidNum, pidStart, pidEnd);
    uint32_t n = 0;            
    uint32_t tmp = 0;
    int x=0;
    int y=0;
    int module=0;
    for(auto it=daqFile.begin();it!=daqFile.end();it++)
    {
        //auto it = daqFile.begin();
        string filename = *it;
        //cout<<123<<endl;
        //cout<<filename<<endl;
        std::ifstream source(filename, std::ifstream::ate|std::ios_base::binary);
        source.seekg (0, source.end);
        int length = source.tellg();
        //cout<<"222: "<<length<<endl;
        source.seekg (0, source.beg);
        const uint8_t * buffer = new uint8_t [length];
        source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
        source.close();
        
        auto *he3 = new Parser::PackageHe3PosCorr(lowerValue,upperValue);
        std::vector<Parser::HitInfo> hitinfo;
        unsigned loop=0, event_cnt = 0;
        const uint8_t * abuf = buffer;
        while(he3->readNextPackage(abuf, buffer+length, hitinfo))
        {
            //event_cnt+=hitinfo.size();
            //cout<<event_cnt<<endl;
            for(auto v: hitinfo)
            {   
                x=v.pos;
                module = v.id;
                y = v.posy;
                tmp = 120-(12*(module-1)+y);
                int pixelID = 100001+bins*(tmp-1)+uint32_t(x/(1000/bins));
                //cout<<x<<"||"<<y<<"||"<<module<<"||"<<tmp<<"||"<<pixelID<<"||"<<v.t<<endl;
            pid.push_back(pixelID);
            tof.push_back(v.t);
            pulse.push_back(v.hit_t0);
            hist2.fill(v.t,pixelID);
            n++;
            }   
        }
        source.close();
        delete [] buffer;
        delete he3;
        cout<<filename<<endl;
    }

    //evtNum = n-1;
    //cout<<"evt num: "<<evtNum<<endl;
    auto tmp2 = hist2.getRaw();
    for(unsigned i=0;i<tmp2.size();i++)
        histData.push_back(tmp2[i]);

}
/*
void ParserNXS::getEventData(string daqFilename, uint64_t& evtNum, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse)
{
    std::ifstream source(daqFilename, std::ifstream::ate|std::ios_base::binary);
    source.seekg (0, source.end);
    int length = source.tellg();
    source.seekg (0, source.beg);
    const uint8_t * buffer = new uint8_t [length];
    //cout<<456<<endl;
    source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
    source.close();

    auto *he3 = new Parser::PackageHe3(0.);
    std::vector<Parser::HitInfo> hitinfo;
    unsigned loop=0, event_cnt = 0;

    const uint8_t * abuf = buffer;
     std::map<uint32_t, uint32_t> mapfile;
        mapfile.insert(make_pair(7,1));
        mapfile.insert(make_pair(8,2));
        mapfile.insert(make_pair(9,3));
        mapfile.insert(make_pair(11,4));
        uint32_t tmp=0;
        uint32_t m_bins = 300;
    uint32_t n = 0;
    while(he3->readNextPackage(abuf, buffer+length, hitinfo))
    {
      event_cnt+=hitinfo.size();
      for(auto v: hitinfo)
      {
        tmp = mapfile[v.tube_id];
        pid.push_back(100001+m_bins*(tmp-1)+int(v.pos));
        tof.push_back(v.t);
        pulse.push_back(v.hit_t0);
        n++;
      }
    }
    evtNum = n-1;
    cout<<"evt num: "<<evtNum<<endl;
}





*/

/*
   void ParserNXS::getMonitorData(string monFile, const int pixels, std::vector<uint32_t> &histData)
   {
//name[0]=toupper(name[0]);

DIR *dirp;
struct dirent *dp;
//string filepath="/opt/CSNSDATA/TS1/BL18/Monitor/Histogram/"+name+"/"+runno;
dirp=opendir(monFilepath.c_str());
while((dp = readdir(dirp))!=NULL)
{if(strlen(dp->d_name)<=3) continue;
string target;
target=monFile+"/"+dp->d_name;
//name[0]=tolower(name[0]);
cout<<target<<endl;
std::ifstream histfile(target.c_str(), ios::binary);
const int timeBin = 40000;
uint32_t** buffer = new uint32_t* [pixels];
if(histfile.is_open())
{
histfile.seekg(0, histfile.end);
histfile.seekg(0, histfile.beg);
for(int i = 0; i< pixels; i++){
buffer[i] = new uint32_t [timeBin];
histfile.read((char*)buffer[i],timeBin*sizeof(uint32_t));
}
histfile.close();
int a=0;
for(int i=0; i<pixels; i++){
for(int j=0; j<timeBin; j++){
a+=buffer[i][j];
histData.push_back(buffer[i][j]);
}
}
cout<<"total neutron counts: "<<a<<endl;
}else{
cout<<"can't open file!"<<endl;
//string path = prepath+"/"+runno+"/no"+name;
//std::ofstream markfile;
//markfile.open(path.c_str());
//markfile.close();
}
}
*/
void ParserNXS::writeGroup(NXstatus status, NXhandle fileID, const char* groupName, const char* groupType)
{
    status=NXmakegroup(fileID,groupName,groupType);
    status=NXopengroup(fileID,groupName,groupType);
}
void ParserNXS::writeCharData(NXstatus status, NXhandle fileID, const std::string dataName, const std::string dataValue)
{
    long unsigned int dsize = dataValue.size();
    if(dsize > std::numeric_limits<int>::max() )
      throw std::runtime_error("ParserNXS::writeCharData, each dimension of the data can't contain more than 2^31 elements");
    int dim[1] = {static_cast<int>(dsize)};
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID,p,NeXus::CHAR,1,dim);
    status=NXopendata(fileID,p);
    status=NXputdata(fileID,dataValue.c_str());
    status=NXclosedata(fileID);
}
//write slab data
void ParserNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    //status=NXmakedata(fileID, p, NX_FLOAT32, 2, dim);
    status=NXcompmakedata(fileID, p, NX_FLOAT32, 2, dim, NX_COMP_LZW, slab_size);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

void ParserNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXcompmakedata(fileID, p, NX_INT64, 2, dim, NX_COMP_LZW, slab_size);
    //status=NXmakedata(fileID, p, NX_INT64, 2, dim);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeSlabData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dim[], int slab_start[], int slab_size[], std::string text)
{
    char* p = (char*)dataName.data();
    //status=NXmakedata(fileID, p, NX_INT32, 2, dim);
    status=NXcompmakedata(fileID, p, NX_INT32, 2, dim, NX_COMP_LZW, slab_size);
    status=NXopendata(fileID, p);
    status=NXputslab(fileID, dataValue, slab_start, slab_size);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}

//if dataValue is a variable, use &dataValue; if dataVale is 2D array, use *dataValue, if dataValue is 1D array, use dataValue
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const float* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_FLOAT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const int64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint64_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT64, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}
void ParserNXS::writeNumData(NXstatus status, NXhandle fileID, const std::string dataName, const uint32_t* dataValue, int dimension, int dim[], std::string text)
{
    char* p = (char*)dataName.data();
    status=NXmakedata(fileID, p, NX_INT32, dimension, dim);
    status=NXopendata(fileID, p);
    status=NXputdata(fileID, dataValue);
    while(text != "")
    {
        NXputattr(fileID,"units",(void*)text.c_str(),static_cast<uint32_t>(text.size()), NX_CHAR);
        break;
    }
    status=NXclosedata(fileID);
}



void ParserNXS::createNXS()
{
    NXaccess mode(NXACC_CREATE5);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXmakegroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"csns","NXentry");
    writeGroup(status, fileID, "instrument", "NXinstrument");
    NXclosegroup(fileID); 
    writeGroup(status, fileID, "event_data", "NXcollection");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "histogram_data", "NXcollection");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "process", "NXprocess");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "user", "NXuser");
    NXclosegroup(fileID);
    writeGroup(status, fileID, "logs", "NXcollection");
    NXclosegroup(fileID);

    NXclosegroup(fileID); //close NXentry
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
}

/***
 * set value into nexus
 ***/
void ParserNXS::setPublic(ParserXML new_xml, string idfFilename)
{
    int dim[1]={1};
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    map<string, string> info = new_xml.getPublic_SUM();
    writeCharData(status, fileID, "description", getStringFromMap(info,"description"));
    writeCharData(status, fileID, "beamline",getStringFromMap(info,"beamline"));
    writeCharData(status, fileID, "start_time_utc",getStringFromMap(info,"start_time_utc"));
    writeCharData(status, fileID, "end_time_utc",getStringFromMap(info,"end_time_utc"));
    writeCharData(status, fileID, "proposal_id", getStringFromMap(info,"proposal_id"));
    writeCharData(status, fileID, "instrument_name",getStringFromMap(info,"instrument_name"));
    writeCharData(status, fileID, "start_time_tai", getStringFromMap(info,"start_time_tai"));
    writeCharData(status, fileID, "end_time_tai", getStringFromMap(info,"end_time_tai"));
    writeCharData(status, fileID, "run_no", getStringFromMap(info,"run_no"));
    writeCharData(status, fileID, "measurement_type", getStringFromMap(info,"measurement_type"));
    writeCharData(status, fileID, "version", "1.0");
    writeCharData(status, fileID, "wavelength", getStringFromMap(info,"wavelength"));
    writeCharData(status, fileID, "proton_charge",getStringFromMap(info,"proton_charge"));
    //float tmp = getFloatFromMap(info,"start_time_tai");
    //writeNumData(status, fileID, "start_time_tai", &tmp, 1, dim, "");
    //tmp = getFloatFromMap(info,"end_time_tai");
    //writeNumData(status, fileID, "end_time_tai", &tmp, 1, dim, "");
    //tmp = getFloatFromMap(info,"proton_charge");
    //writeNumData(status, fileID, "proton_charge", &tmp, 1, dim, "");

    info.clear();
    writeCharData(status, fileID, "instrument_bank_file", "bank.xml");
    //writeCharData(status, fileID, "instrument_monitor_file", "monitor.xml");
    std::string det_definition = "";
    //std::string mon_definition = "";
    fstream fileidf;
    fileidf.open(idfFilename, std::ios::in);
    std::stringstream tmp1;
    tmp1<<fileidf.rdbuf();
    det_definition = tmp1.str();
    fileidf.close();
    //fileidf.open(mdfFilename, std::ios::in);
    //std::stringstream tmp2;
    //tmp2<<fileidf.rdbuf();
    //mon_definition = tmp2.str();
    //fileidf.close();
    writeCharData(status, fileID, "instrument_bank_definition", det_definition);
    //writeCharData(status, fileID, "instrument_monitor_definition", mon_definition);

    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    //cout<<"finish set pub"<<endl;
}

void ParserNXS::setModerator(NXstatus status, NXhandle fileID, map<string, string> info)
{
    bool judge = judgeMap(info);
    if(judge) 
    {
    int dim[1]={1};
    writeGroup(status, fileID, "moderator", "NXmoderator");
    writeCharData(status, fileID, "type", getStringFromMap(info,"type"));
    dim[0]=1;
    float tmp = getFloatFromMap(info,"distance");
    writeNumData(status, fileID, "distance", &tmp, 1, dim, "m");
    tmp = getFloatFromMap(info,"temperature");
    writeNumData(status, fileID, "temperature", &tmp, 1, dim, "K");
    NXclosegroup(fileID);
    }
}

void ParserNXS::setSource(NXstatus status, NXhandle fileID,  map<string, string> info)
{
    bool judge = judgeMap(info);
    if(judge)
    {
    int dim[1]={1};
    writeGroup(status, fileID, "source", "NXsource");
    writeCharData(status,fileID,"name",getStringFromMap(info,"name"));
    writeCharData(status,fileID,"type", getStringFromMap(info,"type"));
    writeCharData(status,fileID,"probe",getStringFromMap(info,"probe"));
    uint32_t tmp = getIntFromMap(info, "frequency");
    writeNumData(status, fileID, "frequency", &tmp, 1, dim, "Hz");
    float tmp2 =  getFloatFromMap(info,"power");
    writeNumData(status, fileID, "power", &tmp2, 1, dim, "W");
    NXclosegroup(fileID);
    }
}
void ParserNXS::setGeometry(NXstatus status, NXhandle fileID, string path, CSNSgeometry info)
{
    int dim[1]={1};
    status=NXopenpath(fileID, path.c_str());
    writeGroup(status, fileID, "geometry", "NXgeometry");
    writeGroup(status, fileID, "shape", "NXshape");
    
    writeCharData(status, fileID, "shape", info.shape);
    if(0==strcmp(info.shape.c_str(),"nxcylinder"))
    {   dim[0] = 2;
    }else{
        dim[0] = 3;
    }
    writeNumData(status, fileID, "size", info.size.data(), 1, dim, "m");
    NXclosegroup(fileID);//close NXshape
    writeGroup(status, fileID, "orientation", "NXorientation");
    dim[0] = 6;
    writeNumData(status, fileID, "value", info.ori.data(), 1, dim, "");
    NXclosegroup(fileID);//close NXorientation
    writeGroup(status, fileID, "translation", "NXtranslation");
    dim[0] = 3;
    writeNumData(status, fileID, "distances", info.distances.data(), 1, dim, "");
    NXclosegroup(fileID);//close NXtranslation
    
    NXclosegroup(fileID);//close geometry
    NXclosegroup(fileID);//close upper
}

void ParserNXS::setSample(NXstatus status, NXhandle fileID,  map<string, string> info)
{
    bool judge = judgeMap(info);
    if(judge)
    {
    int dim[1]={1};
    writeGroup(status, fileID, "sample", "NXsample");
    writeCharData(status,fileID,"name",getStringFromMap(info,"name"));
    writeCharData(status,fileID,"type", getStringFromMap(info,"type"));
    writeCharData(status,fileID,"situation",getStringFromMap(info,"situation"));
    writeCharData(status,fileID,"chemical_formular",getStringFromMap(info,"chemical_formular"));
    float tmp = getIntFromMap(info, "density");
    writeNumData(status, fileID, "density", &tmp, 1, dim, "Hz");
    tmp =  getFloatFromMap(info,"mass");
    writeNumData(status, fileID, "mass", &tmp, 1, dim, "W");
    NXclosegroup(fileID);
    }
}

void ParserNXS::setDC(NXstatus status, NXhandle fileID, const vector<map<string, string>>& info)
{
    bool judge = judgeVector(info);
    if(judge)
    {
    int dim[1]={1};
    float value = 0.0;
    for(auto it=info.begin();it!=info.end();it++)
    {
        map<string, string> tmp = *it;
        const string gName=getStringFromMap(tmp, "DCname");
        writeGroup(status, fileID, gName.c_str(), "NXdisk_chopper");
        value = getFloatFromMap(tmp, "phase");
        writeNumData(status, fileID, "phase", &value, 1, dim, "degree");
        value = getFloatFromMap(tmp, "slit_angle");
        writeNumData(status, fileID, "slit_angle", &value, 1, dim, "degree");
        value = getFloatFromMap(tmp, "rotation_speed");
        writeNumData(status, fileID, "rotation_speed", &value, 1, dim, "Hz");
        value = getFloatFromMap(tmp, "distance");
        writeNumData(status, fileID, "distance", &value, 1, dim, "m");
        tmp.clear();
        NXclosegroup(fileID);
    }
    }
}
void ParserNXS::setSE(NXstatus status, NXhandle fileID, const vector<map<string, string>>& info)
{
    bool judge = judgeVector(info);
    if(judge)
    {
    writeGroup(status, fileID, "sample_environment", "NXcollection");
    int dim[1] = {1};
    for(auto it=info.begin();it!=info.end();it++)
    {
        map<string, string> tmp = *it;
        coutMap(tmp); 
        const string gName=getStringFromMap(tmp, "SEname");
        writeGroup(status, fileID, gName.c_str(), "NXenvironment");
        writeCharData(status,fileID,"name",getStringFromMap(tmp,"name"));
        writeCharData(status,fileID,"type",getStringFromMap(tmp,"type"));
        NXclosegroup(fileID);
    }
    NXclosegroup(fileID);
    }
}
void ParserNXS::setAperture(NXstatus status, NXhandle fileID, const vector<map<string, string>>& info, string name, string typeName)
{
    bool judge = judgeVector(info);
    if(judge)
    {
    int dim[1]={1};
    float value = 0.0;
    for(auto it=info.begin();it!=info.end();it++)
    {
        map<string, string> tmp = *it;
        const string gName=getStringFromMap(tmp, name);
        writeGroup(status, fileID, gName.c_str(), typeName.c_str());
        value = getFloatFromMap(tmp, "xgap");
        writeNumData(status, fileID, "xgap", &value, 1, dim, "meter");
        value = getFloatFromMap(tmp, "ygap");
        writeNumData(status, fileID, "ygap", &value, 1, dim, "meter");
        tmp.clear();
        NXclosegroup(fileID);
    }
    }
}

void ParserNXS::setInstrument(ParserXML new_xml)
{
    cout<<"============================="<<endl;    
    cout<<"start set instrument!"<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);

    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");
  
    map<string, string> moderatorInfo = new_xml.getModerator_SUM();
        setModerator(status, fileID, moderatorInfo);
    moderatorInfo.clear();
    
    map<string, string> sourceInfo = new_xml.getSource_SUM();
        setSource(status, fileID, sourceInfo);
    sourceInfo.clear();
 
    vector<map<string, string> > DCinfo = new_xml.getDC_SUM();
        setDC(status, fileID, DCinfo);
    DCinfo.clear();    
    
    vector<map<string, string> > SEinfo = new_xml.getSE_SUM();
        setSE(status, fileID, SEinfo);
    SEinfo.clear();    
    
    vector<map<string, string> > slitInfo = new_xml.getSlit_SUM();
    setAperture(status, fileID, slitInfo, "slitName", "NXslit");
    slitInfo.clear();    
    vector<map<string, string> > apertureInfo = new_xml.getAperture_SUM();
    setAperture(status, fileID, apertureInfo, "apertureName", "NXaperture");
    apertureInfo.clear();    

    map<string, string> sampleInfo = new_xml.getSample_SUM();
    setSample(status, fileID, sampleInfo);
    sampleInfo.clear();
    
    //CSNSgeometry sampleGeo_info = new_xml.getGeometry("NXsample");
    //setGeometry(status, fileID,"/csns/instrument/sample", sampleGeo_info);

    NXclosegroup(fileID);//close instrument
    NXclosegroup(fileID); //close csns
    NXclose(&fileID);
    cout<<"finish instrument"<<endl;
}

void ParserNXS::setPid(NXstatus status, NXhandle fileID, int idstart, const int xpid, const int ypid)
{
    int dim2D[2]={ypid,xpid};
    vector<int64_t> pixelId;
    for (int i=0; i<xpid*ypid;i++){
        pixelId.push_back(idstart+i);
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid, xpid};
    writeSlabData(status, fileID, "pixel_id", pixelId.data(), dim2D, slab_start, slab_size, "");
    pixelId.clear();
}

//void ParserNXS::setCoordinate_module(NXstatus status, NXhandle fileID, , const int xpid, const int ypid)
void ParserNXS::setCoordinate(NXstatus status, NXhandle fileID,float xpos, float ypos, float zpos, float xstep, float ystep, float rotValue, const int xpid, const int ypid)
{
    int dim2D[2]={ypid, xpid};
    float *x=new float[xpid*ypid];
    float *y=new float[xpid*ypid];
    float *z=new float[xpid*ypid];
    int num=0;
    for (int i=0; i<xpid; i++){
        for (int j=0; j<ypid;j++){
            z[num]= -sin(rotValue/180*M_PI)*(j*xstep)+zpos;
            x[num]= xpos +cos(rotValue/180*M_PI)*(j*xstep);
            y[num]= ypos+i*ystep;
        }
        num++;
    }
    float *ra_distance=new float [xpid*ypid];
    float *az_angle=new float [xpid*ypid];
    float *po_angle=new float [xpid*ypid];
    for (int i=0; i<xpid*ypid; i++){
        ra_distance[i]= sqrt(x[i]*x[i]+y[i]*y[i]+z[i]*z[i]);
        az_angle[i]= 180/M_PI*acos(z[i]/ra_distance[i]);
        po_angle[i]= 180/M_PI*atan(y[i]/x[i]);
    }
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "radial_distance", ra_distance, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "polar_angle", po_angle, dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "azimuthal_angle", az_angle, dim2D, slab_start, slab_size, "");
    delete [] x;
    delete [] y;
    delete [] z;
    delete [] ra_distance;
    delete [] az_angle;
    delete [] po_angle;
}



void ParserNXS::setPidSize(NXstatus status, NXhandle fileID, float xstep,float ystep, const int xpid, const int ypid)
{
    vector<float> x_pixel_size;
    vector<float> y_pixel_size;
    float z_pixel_size=0.0005;
    for(int i=0; i<xpid*ypid; i++){
        x_pixel_size.push_back(xstep);
        y_pixel_size.push_back(ystep);
    }
    int dim[1]={1};
    int dim2D[2]={ypid, xpid};
    int slab_start[2]={0,0};
    int slab_size[2]={ypid,xpid};
    writeSlabData(status, fileID, "x_pixel_size", x_pixel_size.data(), dim2D, slab_start, slab_size, "");
    writeSlabData(status, fileID, "y_pixel_size", y_pixel_size.data(), dim2D, slab_start, slab_size, "");
    writeNumData(status, fileID, "z_pixel_size", &z_pixel_size, 1, dim, "");
    x_pixel_size.clear();
    y_pixel_size.clear();
}

void ParserNXS::setTof(NXstatus status, NXhandle fileID,const int tStart, const int tBin, const int tStep, const uint32_t delay)
{
    int dim[1]={0};
    vector<uint32_t> tof;
    int tDelay=0;
    if(delay>1)
        tDelay = delay;
    for(uint32_t i=0; i<tBin; i++)
        tof.push_back(tStart+tDelay+i*tStep);
    dim[0]=tBin;
    writeNumData(status, fileID, "time_of_flight", tof.data(), 1, dim, "");
    dim[0]=1;
    writeNumData(status, fileID, "delay", &delay, 1, dim, "us");
    tof.clear();
}


void ParserNXS::getHistDataFromDrone(string prepath, string moduleName, std::vector<uint32_t> &histData)
{
    string path = prepath+"/hist_"+moduleName+".dat";
    cout<<"hist data path "<<path<<endl;
    std::ifstream histfile(path.c_str());
    string histbuff;
    uint64_t n = 0;
    vector<string> substring;
    if(histfile.is_open()){
        while(getline(histfile, histbuff)){
            substring = split(histbuff, ";");
            for (int i = 0; i<substring.size(); i++){
                histData.push_back(atoi(substring[i].c_str()));
                n++;
            }
        }
        cout<<substring.size()<<";"<<n<<endl;
        histfile.close();
    }else{
        cout<<"can't open daq file!"<<endl;
        string path = prepath+"/noDAQ";
        std::ofstream markfile;
        markfile.open(path.c_str());
        markfile.close();
    }
}

void ParserNXS::getMultiHistData(string prepath, std::vector<uint32_t> &histData)
{
    for(auto i = 1; i<11; i++)
    {
        string mName = "module"+int2string(i);
        getHistDataFromDrone(prepath,  mName, histData);
    }
}

void ParserNXS::getMultiEvtData(string prepath,std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse)
{
     for(auto i = 1; i<11; i++)
    {
        string mName = "module"+int2string(i);
        getEvtDataFromDrone(prepath, mName,pid,tof,pulse); 
    }
}

void ParserNXS::getEvtDataFromDrone(string prepath,string moduleName, std::vector<int64_t> &pid, std::vector<float> &tof, std::vector<uint64_t> &pulse)
{
    string path = prepath+"/evt_"+moduleName+".dat";
    cout<<"evt data path "<<path<<endl;
    std::ifstream evtfile(path.c_str());
    string evtbuff;
    if(evtfile.is_open()){
        while(getline(evtfile, evtbuff)){
            vector<string> substring;
            substring = split(evtbuff, ";");
            pid.push_back(atoi(substring[0].c_str()));
            tof.push_back(atof(substring[1].c_str()));
            pulse.push_back(atoi(substring[2].c_str()));
        }
        evtfile.close();
    }else{
        cout<<"can't open daq file!"<<endl;
        string path = prepath+"/noDAQ";
        std::ofstream markfile;
        markfile.open(path.c_str());
        markfile.close();
    }
}

void ParserNXS::getMonitorData(string filename, const int pids, const int tBins, std::vector<uint32_t> &histData)
{
    std::ifstream histfile(filename.c_str(), ios::binary);
    uint32_t** buffer = new uint32_t* [pids];
    if(histfile.is_open())
    {
        histfile.seekg(0, histfile.end);
        histfile.seekg(0, histfile.beg);
        for(int i = 0; i< pids; i++){
            buffer[i] = new uint32_t [tBins];
            histfile.read((char*)buffer[i],tBins*sizeof(uint32_t));
        }
        histfile.close();
        int a=0;
        uint64_t n = 0;
        for(int i=0; i<pids; i++){
            for(int j=0; j<tBins; j++){
                a+=buffer[i][j];
                histData.push_back(buffer[i][j]);
                n++;
            }
        }
        cout<<"total neutron counts: "<<a<<endl;
    }
}

void ParserNXS::setBank(ParserXML conf_xml,ParserXML sum_xml, ParserXML idf_xml, const vector<string> &dataPath)
{
    cout<<"start set detector: "<<endl;
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    int dim[1]={1};
    int slab_start[2]={0,0};
    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");
    uint64_t evtNum=0;
    map<string, string> tofInfo = conf_xml.getTofInfo_CONF("bankTofInformation");
    map<string, string> bankInfo = sum_xml.getBank_SUM();    
    int timeBin = getIntFromMap(tofInfo, "tofbin")+1; 
    int timeStart = getIntFromMap(tofInfo, "tofstart"); 
    int timeStep = getIntFromMap(tofInfo, "tofstep"); 
    int delay = getIntFromMap(bankInfo,"delay");

    cout<<"123: "<<timeStart<<endl;
    string localName = getStringFromMap(bankInfo, "local_name");
    string instName = conf_xml.getInstName_CONF();

    vector<string> moduleList = conf_xml.getModuleList_CONF("bank");
    cout<<"123: "<<instName<<endl;


    for(auto it = moduleList.begin(); it!=moduleList.end(); it++)
    {
        string moduleName = *it;
        cout<<"123: "<<moduleName<<endl;

        writeGroup(status, fileID, moduleName.c_str(), "NXdetector");
        map<string, string> modulePos = idf_xml.getModulePos_IDF(moduleName);
        dim[0]=1;
        if(0==strcmp(instName.c_str(),"MR"))
        {
            string detMode = getStringFromMap(bankInfo, "detector_mode");
            float rotateAngle = getFloatFromMap(bankInfo, "rotate_angle");
            float distance = getFloatFromMap(bankInfo, "distance"); //unit is mm
            writeNumData(status, fileID, "rotate_angle", &rotateAngle, 1, dim, "degree");
            writeNumData(status, fileID, "distance", &distance, 1, dim, "mm");
            writeCharData(status, fileID, "detector_mode", detMode);
        }

        writeCharData(status, fileID, "local_name", localName);

        map<string, string> pidInfo = conf_xml.getPid_CONF(moduleName);

        int xpid = getIntFromMap(pidInfo,"xpixels");
        int ypid = getIntFromMap(pidInfo,"ypixels");
        int idstart = getIntFromMap(pidInfo,"idstart");
        //cout<<"123: "<<xpid<<endl;
        setPid(status, fileID, idstart, xpid, ypid);
        float xstep = getFloatFromMap(pidInfo, "xsize"); 
        float ystep = getFloatFromMap(pidInfo, "ysize"); 
        //cout<<"123: "<<xstep<<endl;
        setPidSize(status, fileID, xstep, ystep, xpid, ypid);

        float xpos = getFloatFromMap(modulePos, "xpos"); 
        float ypos = getFloatFromMap(modulePos, "ypos"); 
        float zpos = getFloatFromMap(modulePos, "zpos"); 
        float rot = getFloatFromMap(modulePos, "rot"); 
        setCoordinate(status, fileID, xpos,ypos,zpos,xstep,ystep,rot,xpid, ypid); 

        setTof(status,fileID,timeStart,timeBin,timeStep, delay);        

        std::vector<int64_t> pid;
        std::vector<float> tof;
        std::vector<uint64_t> pulse;

        std::vector<uint32_t> histData;
        uint32_t cnt = 0;
        if(instName == "SANS")
        {
            map<string, string> threshold = conf_xml.getTHInfo_CONF("threshold");
            int tofEnd = timeStart+timeStep*(timeBin-1);
            float upValue = getFloatFromMap(threshold, "up_value");
            float downValue = getFloatFromMap(threshold, "down_value");
            //cout<<"111: "<<upValue<<endl;
            getSANSData(dataPath, xpid*ypid, idstart, timeBin-1, timeStart, tofEnd, pid,tof,pulse, histData, downValue, upValue, xpid);
        }
        evtNum = pid.size();
        dim[0]= evtNum;
        writeNumData(status, fileID, "event_pixel_id", pid.data(), 1, dim, "");
        writeNumData(status, fileID, "event_time_of_flight", tof.data(), 1, dim, "");
        writeNumData(status, fileID, "event_pulse_time", pulse.data(), 1, dim, "");
        cout<<"finish set evt_data"<<endl;
        pid.clear();
        tof.clear();
        pulse.clear();
        
        int slab_size[2]={ypid*xpid,(timeBin-1)};
        int dim2D[2]={xpid*ypid, timeBin-1};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D,slab_start, slab_size, "");
        cout<<"finish set hist_data"<<endl;
        histData.clear();

        NXclosegroup(fileID);//close module
    }

    tofInfo.clear();
    bankInfo.clear();

    moduleList.clear();

    NXclosegroup(fileID);
    NXclosegroup(fileID);
    NXclose(&fileID);
}

void ParserNXS::setMonitor(ParserXML conf_xml,ParserXML sum_xml, ParserXML idf_xml, map<string, string>fileList)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    int dim[1]={1};
    int slab_start[2]={0,0};
    status=NXopengroup(fileID,"csns","NXentry");
    status=NXopengroup(fileID,"instrument","NXinstrument");
    map<string, string> tofInfo = conf_xml.getTofInfo_CONF("monTofInformation");
    vector<map<string, string> > monitorInfo = sum_xml.getMon_SUM();    

    int timeBin = getIntFromMap(tofInfo, "tofbin")+1; 
    int timeStart = getIntFromMap(tofInfo, "tofstart"); 
    int timeStep = getIntFromMap(tofInfo, "tofstep"); 

    for(auto it = fileList.begin(); it!=fileList.end(); it++)
    {
        string monName = it->first;
        cout<<"start set monitor: "<<monName<<endl;
        writeGroup(status, fileID, (it->first).c_str(), "NXmonitor");
        monName[0]=toupper(monName[0]);
        map<string, string> tmp = getMapFromVector(monitorInfo, "monitorName", monName);
        int delay = getIntFromMap(tmp, "delay");
        setTof(status,fileID,timeStart,timeBin,timeStep, delay);        
        string localName = getStringFromMap(tmp, "local_name");
        writeCharData(status, fileID, "local_name", localName);    
        tmp.clear();

        map<string, string> pidInfo = conf_xml.getPid_CONF(it->first);
        int xpid = getIntFromMap(pidInfo,"xpixels");
        int ypid = getIntFromMap(pidInfo,"ypixels");
        int idstart = getIntFromMap(pidInfo,"idstart");
        setPid(status, fileID, idstart, xpid, ypid);

        float xstep = getFloatFromMap(pidInfo, "xsize"); 
        float ystep = getFloatFromMap(pidInfo, "ysize"); 
        setPidSize(status, fileID, xstep, ystep, xpid, ypid);

        string filename = it->second;
        cout<<filename<<endl;
        std::vector<uint32_t> histData;
        getMonitorData(filename, xpid*ypid, timeBin,histData);
        int slab_size[2]={ypid*xpid,(timeBin-1)};
        int dim2D[2]={xpid*ypid, timeBin-1};
        writeSlabData(status, fileID, "histogram_data",histData.data(), dim2D,slab_start, slab_size, "");
        histData.clear();

        NXclosegroup(fileID);//close monitor
    }
    NXclosegroup(fileID);
    NXclosegroup(fileID);
    NXclose(&fileID);

}

void ParserNXS::setEventData(const std::vector<string> &dName)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    for(auto it = dName.begin(); it != dName.end(); it++){
        string name = *it;
        NXlink eventPixelIdLink;
        NXlink eventPulseTimeLink;
        NXlink eventTimeOfFlightLink;
        string path ="/csns/instrument/"+name;
        string pathEventPixelId = path+"/event_pixel_id";
        string pathEventPulseTime = path+"/event_pulse_time";
        string pathEventTimeOfFlight = path+"/event_time_of_flight";
        string pathEventData="/csns/event_data";
        status=NXopenpath(fileID, pathEventPixelId.c_str());
        status=NXgetdataID(fileID, &eventPixelIdLink);
        status=NXopenpath(fileID, pathEventPulseTime.c_str());
        status=NXgetdataID(fileID, &eventPulseTimeLink);
        status=NXopenpath(fileID, pathEventTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &eventTimeOfFlightLink);
        status=NXopenpath(fileID, pathEventData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXevent_data");
        status=NXmakelink(fileID, &eventPixelIdLink);
        status=NXmakelink(fileID, &eventPulseTimeLink);
        status=NXmakelink(fileID, &eventTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close event
    }
    NXclosegroup(fileID);//close csns
    NXclose(&fileID);
}
void ParserNXS::setHistData(const std::vector<string> &dName)
{
    NXaccess mode(NXACC_RDWR);
    NXstatus status;
    NXhandle fileID;
    uint32_t compression(NX_COMP_LZW);
    status=NXopen(nxsfile.c_str(), mode, &fileID);
    status=NXopengroup(fileID,"csns","NXentry");
    for (auto it = dName.begin(); it != dName.end(); it++)
    {
        string name = *it;
        string path ="/csns/instrument/"+name;
        NXlink HistTimeOfFlightLink;
        NXlink HistValueLink;
        string pathValue = path+"/histogram_data";
        string pathTimeOfFlight = path+"/time_of_flight";
        string pathHistData="/csns/histogram_data";
        status=NXopenpath(fileID, pathValue.c_str());
        status=NXgetdataID(fileID, &HistValueLink);
        status=NXopenpath(fileID, pathTimeOfFlight.c_str());
        status=NXgetdataID(fileID, &HistTimeOfFlightLink);
        status=NXopenpath(fileID, pathHistData.c_str());

        writeGroup(status, fileID, name.c_str(), "NXdata");
        status=NXmakelink(fileID, &HistValueLink);
        status=NXmakelink(fileID, &HistTimeOfFlightLink);
        NXclosegroup(fileID);
        NXclosegroup(fileID);//close hist
    }
    NXclosegroup(fileID);//clsoe csns
    NXclose(&fileID);
}


