#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"

int main()
{
	std::cout << "Starting client..." << std::endl;
  unsigned pid_num(4600), tof_num(2500);


	std::shared_ptr<RedisIO> redis(
		new RedisIO( 9001, "neonmaster", "sanlie;123"));
  //redis should retrive all parameters
  std::shared_ptr<Hist2DMap> histmap(
		new Hist2DMap(tof_num, 0 , 40000, pid_num, -.5, pid_num-.5 , Hist2DMap::DetectorType::kMWPC,1) );

  //RunNumber runNumber;
	DAQInterface daq("dimserver/TEST_SWAP_0",1000);
	daq.setActive(true);
  daq.setHist2DMap(histmap);

	std::vector<double> pid;
	for(unsigned i=0;i<pid_num;i++)
	  pid.push_back(i+1);
	RedisNumpy nvt;
  std::string pidstr;
	std::vector<uint64_t> shape;
	shape.push_back(pid_num);
	nvt.makeNumpyArr(pid, RedisNumpy::data_type::f8,
									 shape, pidstr);
	// redis->writeString("/sim/MR/workspace/detector/module1/pid", pidstr);

	std::vector<double> tof;
	for(unsigned i=0;i<tof_num+1;i++)
	{
		tof.push_back(i*16);
	}
	std::string tofstr;
	shape[0]=(tof_num+1);
	nvt.makeNumpyArr(tof, RedisNumpy::data_type::f8,
									 shape, tofstr);
	// redis->writeString("/sim/MR/workspace/detector/module1/tof", tofstr);
  auto start = std::chrono::steady_clock::now();

  unsigned loop=100;
	while(loop)
	{

		loop--;
		EW_LOG_INFO("Data integral {}", histmap->getIntegral());

		std::this_thread::sleep_for(std::chrono::milliseconds(100));
    std::string str;
		histmap->makeNumpyRaw(str,std::vector<unsigned>{1});
		// redis->writeString("/sim/MR/workspace/detector/module1/value", str);

	}

	double t=std::chrono::duration_cast<std::chrono::seconds>(std::chrono::steady_clock::now()
	             - start).count();
  std::cout << "speed is "  << t/100 << "s per loop\n"
	<< histmap->getIntegral()/t << "event/s \n";
	//histmap->getHistMapBegin()->second->save("mwpc.npy");
  return 0;
}
