#!/usr/bin/python

from __future__ import print_function
import time
import sys
import h5py
import numpy as np
from xlib.Trajectory import Trajectory


radpsec2meV =  6.5821e-13
radpfs2meV = radpsec2meV*1e15

fname = 'dump_h5md.h5'
out = 'mdana.h5'
pairs = None
if len(sys.argv)==2:
    fname = sys.argv[1]


trj = Trajectory(fname)



maxTimeWindowFs = 1.e2
maxTimeStep =  maxTimeWindowFs/ trj.deltaTfs
nTimeStep = np.min([maxTimeStep, trj.nFrame//2])
timeStep=np.arange(0, nTimeStep, 1,dtype=np.uint32)
timeStep=np.arange(0, 1, 1,dtype=np.uint32)
print('time window sizes are between', timeStep[0] , 'and',timeStep[-1])

Q=np.arange(1,100)*0.3407674782939435

start_time = time.time()
Sq=trj.structFact( (1,0) , (1,1),  Q, timeStep)
# Sq=trj.intermediate( (1,0) , (1,1),  Q, timeStep )

import matplotlib.pyplot as plt
plt.plot(Q,Sq[0,:])
plt.show()
