#ifndef StructureFactor_hh
#define StructureFactor_hh
#include <stdexcept>
#include <vector>
#include "ctypes_api.hh"
#include "TrajAna.hh"
#ifdef __cplusplus
extern "C" {
#endif

EXPORT_SYMBOL void structFact(double* traj, unsigned trajSize,
    unsigned *atomicPair, unsigned atomicPairSize,
    double *box, unsigned boxSize,
    double *q, unsigned qSize,
    unsigned *timeStep, unsigned TimStepSize,
    unsigned nAtom, unsigned nTimeStep, double* FsTQ, unsigned FsTQSize);


void structFactRaw(const std::vector<double*>& atomPos1, const std::vector<double*>& atomPos2, unsigned nTimeStep, unsigned timeIdx,
    double *box, unsigned boxSize, double *q, unsigned qSize, std::vector<double>& fq);

void structFactHistT(const std::vector<double*>& atomPos1, const std::vector<double*>& atomPos2, unsigned nTimeStep, unsigned timeIdx,
    double *box, unsigned boxSize, double *q, unsigned qSize, std::vector<double>& fq);


#ifdef __cplusplus
}
#endif

#endif
