#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
import matplotlib.pyplot as plt
from xlib import *

fname = 'dump_h5md.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

trj = Trajectory(fname)
print ('getAtomType', trj.getAtomType())


timeStep = np.unique(np.logspace(0,4,20,dtype=np.uint32))
Q=np.array([1.6, 3])
start_time = time.time()
fsqt_H=trj.incoherentIntermediate(2, Q, timeStep)
print  ('time ' , time.time() - start_time, 's')

for res, aq in zip(fsqt_H.T, Q):
    plt.semilogx(timeStep*trj.getDeltaT()*1e-3, res, 'o', label='Q='+str(aq))

# print(FsTQ)
dataabe=np.loadtxt('abe2015fig1.dat')
plt.semilogx(dataabe[:,0],dataabe[:,1], zorder=100, label='Q=1.6A^-1')

plt.legend()
plt.xlabel('time, ps')
plt.ylabel('Fs(Q,t)')

plt.show()
