#!/usr/bin/python
#to do.
#1. make ungarded fill inline
#2. make normal fill
from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
from xlib import *

fname = 'dump_h5md.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]

f=h5py.File(fname,'r')

#[step, atom, value]
species=f['particles']['all']['species']['value'][()]

def trim(data, spe, key):
  # old_shape = data.shape
  # data=data[spe==key,:]
  # atomLeft = data.shape[0]/old_shape[0]
  # #1. get the corret shape
  # data=data.reshape([old_shape[0], atomLeft, 3])
  # #2. swap axes from [stepID, atomID, vector3] to [atomID, stepID, vector3]
  data=np.swapaxes(data,0,1)
  #3. make data contiguous
  #index used to be "timestep, "
  #pos, trj, atom
  return np.ascontiguousarray(data)

def getDeltaT(time):
  return (time[1]-time[0])  #in fetosecond

pos = trim(f['particles']['all']['position']['value'][()],species,1)
deltaTfs = getDeltaT(f['particles']['all']['species']['time'][()]) #in fs
box=f['particles']['all']['box']['edges']['value'][()]
f.close()

nStep= pos.shape[1]
nAtom = pos.shape[0]

#1 rad/sec = 6.5821e-16 eV
radpsec2meV =  6.5821e-13 * 2*np.pi
radpps2meV =  radpsec2meV*1e12
radpfs2meV =  radpsec2meV*1e15

print ('Delta time ',deltaTfs,'fs')
print ('Poisiton size after trim ', pos.shape)
print ('box size', box.shape)



import matplotlib.pyplot as plt
# data35=np.loadtxt('fsq0.35.dat')
# data74=np.loadtxt('fsq0.74.dat')
# data100=np.loadtxt('fsq1.00.dat')
#
# plt.semilogx(data35[:,0],data35[:,1], label='0.35A^-1')
# plt.semilogx(data74[:,0],data74[:,1], label='0.74A^-1')
# plt.semilogx(data100[:,0],data100[:,1], label='1.00A^-1')

dataabe=np.loadtxt('abe2015fig1.dat')
plt.semilogx(dataabe[:,0],dataabe[:,1], zorder=100, label='Q=1.6A^-1')
#####c

rSize= 1000
tSize = nStep/5
wlCut = 12.

timeStep = np.unique(np.logspace(0,4,200,dtype=np.uint32))

minQ = 1.6
qSize = 1
FsTQ = np.zeros([timeStep.size, qSize ], dtype = np.float64)

atomID = np.arange(0, 648, 3, dtype=np.uint32)
atomicPair = np.ascontiguousarray(np.tile(atomID,(2,1)).swapaxes(0,1))
atomicPair[:,1]+=1
atomicPair[:,0]+=1

start_time = time.time()

vacf.intermediate(pos, pos.size,
    atomicPair, atomicPair.size,
    box, box.size,
    minQ, qSize,
    timeStep, timeStep.size,
    nAtom, nStep, FsTQ, FsTQ.size);
plt.semilogx(timeStep*deltaTfs*1e-3, FsTQ, 'o', label='cal Q='+ str(minQ))
# print(FsTQ)
print  ('time ' , time.time() - start_time, 's')
plt.legend()

plt.xlabel('time, ps')
plt.ylabel('Fs(Q,t)')

plt.show()
