#include "parserXML.h"
#include <typeinfo>
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <typeinfo>
#include "tinyxml.h"

using namespace std;
/*******
This is for private
********/

void ParserXML::coutMap(map<string, string> info)
{
    for(auto it = info.begin(); it!=info.end(); it++)
        cout<<it->first<<"||"<<it->second<<endl;
}


vector<string> ParserXML::split(string str, string sep)
{
   char* cstr=const_cast<char*>(str.c_str());
    char* current;
    std::vector<std::string> arr;
    current=strtok(cstr,sep.c_str());
    while(current!=NULL){
        arr.push_back(current);
        current=strtok(NULL,sep.c_str());
    }
    return arr;
}

void ParserXML::findNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName)
{
    if(0==strcmp(nodeName, tree->Value()))
    {
        destNode=tree;
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement()){
        if(0==strcmp(nodeName,pNode->Value()))
        {
            destNode=pNode;
        }else{
            findNode(pNode, destNode,nodeName);}
    }
}

void ParserXML::findNode(TiXmlElement *tree, TiXmlElement * &destNode, const char* nodeName, const char* attrName, const char* attrValue)
{
    TiXmlAttribute *attr;
    if(0==strcmp(nodeName, tree->Value()))
    {
        for(attr=tree->FirstAttribute();attr!=NULL; attr=attr->Next())
        {
            if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue)))
            {
                destNode=tree;
            }
        }
    }
    TiXmlElement *pNode=tree;
    for(pNode=pNode->FirstChildElement();pNode!=NULL;pNode=pNode->NextSiblingElement())
    {
        if(0==strcmp(nodeName,pNode->Value()))
        {
            for(attr=pNode->FirstAttribute();attr!=NULL; attr=attr->Next())
            {
                if((0==strcmp(attr->Name(), attrName)) && (0==strcmp(attr->Value(),attrValue))){
                    destNode=pNode;
                }
            }
        }else
            findNode(pNode,destNode,nodeName,attrName,attrValue);
    }    
}

/***
 * obtain text value from known node
 ***/
std::string ParserXML::getTextValue(TiXmlElement *knowNode)
{
    TiXmlNode *node;
    std::string text="None";
    node=knowNode->FirstChild();
    //cout<<"333: "<<node->Type()<<endl;
    if (node && node->Type()==TiXmlNode::TINYXML_TEXT)
        text = node->ToText()->Value();
    cout<<text<<endl;
    return text;
}

float ParserXML::string2float(string name)
{
    if(0==strcmp(name.c_str(), "None"))
    {  return 0.0;
    }else{
        return atof(name.c_str());
    }
}

vector<string> ParserXML::getTextArray(TiXmlElement *knowNode)
{
    vector<string> data;
    const char* str;
    TiXmlNode *node;
    node=knowNode->FirstChild();
    if (node && node->Type()==TiXmlNode::TINYXML_TEXT)
    {
        str=node->ToText()->Value();
        data = split(str," ");
    }
    return data;
}

vector<float> ParserXML::vecString2float(const vector<string> &vec, int num)
{
    vector<float> data;
    if (vec.size()!=num)
    {
        for (auto i = 0; i<num; i++)
            data.push_back(0.0);
    }else{
     for(auto it = vec.begin(); it!=vec.end();it++)
        data.push_back(atof((*it).c_str()));
    }
    return data;
}

vector<float> ParserXML::findTextArray(TiXmlElement *knowNode, const char* nodeName, int num)
{
    vector<float> data;
    TiXmlElement *node;
    findNode(knowNode, node, nodeName);
    if(0==strcmp(node->Value(),nodeName))
    {
        vector<string> tmp;
        tmp = getTextArray(node);
        data = vecString2float(tmp,num);
        tmp.clear();
    }
    return data;
}

map<string, string> ParserXML::getAllSonNodeAndTextValue(TiXmlElement *knowNode)
{
    //cout<<"getAllSonNodeAndTextValue"<<endl;
    TiXmlElement *node;
    map<string, string> data;
    string tmp;
    for(node=knowNode->FirstChildElement();node!=NULL; node=node->NextSiblingElement())
    {
        //cout<<node->Value()<<endl;
        tmp = getTextValue(node);
        //cout<<tmp<<endl;
        if (0!=strcmp(tmp.c_str(), "None"))
            data.insert(make_pair(node->Value(),tmp));
    }
    return data;
}

/***
 * obtain attr value from known node
 ***/
map<string, string> ParserXML::findAllAttrValues(TiXmlElement *knowNode)
{
    std::map<string, string> data;
    TiXmlAttribute *attr;
        for(attr=knowNode->FirstAttribute();attr!=NULL;attr=attr->Next())
            data.insert(make_pair(attr->Name(),attr->Value()));
    
    return data;
}

string ParserXML::getSpecialAttrValue(TiXmlElement *knowNode,const char* attrName)
{
    TiXmlAttribute *attr;
    string data="";
    for(attr=knowNode->FirstAttribute();attr!=NULL;attr=attr->Next())
    {
        if(0==strcmp(attr->Name(),attrName))
            data = attr->Value();
    }
    return data;
}
/***
 * general get info from summary
 ***/
map<string, string> ParserXML::getOneComponent(string NXname)
{
    TiXmlElement *node=root;
    map<string, string> data;
    findNode(root, node, NXname.c_str());
    //cout<<node<<";"<<node->Value()<<endl;
    if(0==strcmp(node->Value(),NXname.c_str()))
    {
        data = getAllSonNodeAndTextValue(node);
    }else{
        cout<<"can't find "<<NXname<<endl;
        data.insert(make_pair("None","None"));
    }    
    return data;
}

vector<map<string, string> > ParserXML::getMultiComponent(string NXname, string typeName)
{
    std::vector<map<string, string> > data;
    TiXmlNode *node;
    TiXmlElement *search=root;
    findNode(root, search, NXname.c_str());
    if(0==strcmp(search->Value(),NXname.c_str()))
    {
        node = search;
        for(node; node!=NULL; node=node->PreviousSibling())
        {
            if((node->Type()==TiXmlNode::TINYXML_ELEMENT)&& (0==strcmp(node->Value(),NXname.c_str())))
            {
                map<string, string> tmp;
                search = node->ToElement();
                tmp = getAllSonNodeAndTextValue(search);
                string tmp2 = getSpecialAttrValue(search, "name");
                tmp.insert(make_pair(typeName,tmp2));
                data.push_back(tmp);
                tmp.clear();
            }
        }
    }else{
        cout<<"can't find "<<NXname<<endl;
        map<string, string> tmp;
        tmp.insert(make_pair("None","None"));
        data.push_back(tmp);
        tmp.clear();    
    }
    return data;
}

/*****
 This is for configure information
 tof and moduleList
*****/
map<string, string> ParserXML::getTofInfo_CONF(string nodeName, const string &bl)
{
    TiXmlElement *search, *psearch;
   findNode(root,search, "instrument", "name", bl.c_str()); 
   findNode(search,psearch, nodeName.c_str()); 
    return findAllAttrValues(psearch);
}

map<string, string> ParserXML::getTHInfo_CONF(string nodeName, const string &bl)
{
    TiXmlElement *search, *psearch;
   findNode(root,search, "instrument", "name", bl.c_str()); 
   findNode(search,psearch, nodeName.c_str()); 
    return findAllAttrValues(psearch);
}

vector<string> ParserXML::getModuleList_CONF(string detectorName, const string &bl)
{
    TiXmlElement *search, *psearch;
   findNode(root,search, "instrument", "name", bl.c_str()); 
    
    vector<string> data;
    findNode(search, psearch, "type" ,"name",detectorName.c_str());
    if(0==strcmp(psearch->Value(),"type"))
    {
        for(search=psearch->FirstChildElement();search!=NULL;search=search->NextSiblingElement())
            data.push_back(getSpecialAttrValue(search, "name"));
    }
    return data;
}

string ParserXML::getPath_CONF(string nodeName,const string &bl)
{
    string data = "None";
    TiXmlElement *search, *psearch;
   findNode(root,search, "instrument", "name", bl.c_str());
    findNode(search, psearch, nodeName.c_str());
    //if(nodeName.compare(psearch->Value())==0)
        data = getTextValue(psearch);
    return data;
}

map<string, string> ParserXML::getPid_CONF(string moduleName,const string &bl)
{
    TiXmlElement *search, *psearch;
    findNode(root,search, "instrument", "name", bl.c_str()); 
    findNode(search,psearch, "component", "name", moduleName.c_str()); 
return findAllAttrValues(psearch);	
}

/*******
This is for summary information
********/
map<string, string>ParserXML::getPublic_SUM()
{
    return getOneComponent("NXentry");
}

map<string, string>ParserXML::getModerator_SUM()
{
    return getOneComponent("NXmoderator");
}

map<string, string>ParserXML::getSource_SUM()
{
    return getOneComponent("NXsource");
}

map<string, string>ParserXML::getSample_SUM()
{
    return getOneComponent("NXsample");
}
map<string, string>ParserXML::getBank_SUM()
{
    return getOneComponent("NXdetector");
}
vector<map<string, string> >ParserXML::getDC_SUM()
{
    return getMultiComponent("NXdisk_chopper", "DCname");
}
vector<map<string, string> >ParserXML::getSE_SUM()
{
    return getMultiComponent("NXenvironment", "SEname");
}
vector<map<string, string> >ParserXML::getSlit_SUM()
{
    return getMultiComponent("NXslit", "slitName");
}
vector<map<string, string> >ParserXML::getAperture_SUM()
{
    return getMultiComponent("NXaperture", "apertureName");
}
vector<map<string, string> >ParserXML::getMon_SUM()
{
    return getMultiComponent("NXmonitor", "monitorName");
}

string ParserXML::getBankMode_SUM()
{
    string data;
    map<string, string> tmp = getOneComponent("NXdetector");
    auto it = tmp.find("detector_mode");
    if(it!= tmp.end())
    {    data = it->second;
    }else{
         data = "";
    }
    return data;
}


CSNSgeometry ParserXML::getGeometry(string nodeName)
{
    CSNSgeometry data;
    TiXmlElement *search, *psearch;
    search = root;
    int num=0;
    cout<<"get Geometry"<<endl;
    findNode(root, search, nodeName.c_str());
    cout<<search<<"||"<<search->Value()<<endl;
    if(0==strcmp(search->Value(), nodeName.c_str()))
    {
        data.ori = findTextArray(search, "value", 6);
        data.distances = findTextArray(search, "distances", 3);
        findNode(search, psearch, "shape");
        if(0==strcmp(psearch->Value(), "shape"))
        {
            data.shape = getTextValue(psearch);
            if(0==strcmp(data.shape.c_str(),"nxcylinder"))
            {
                num=2;
            }else{
                num = 3;
            }
        }
        data.size = findTextArray(search, "size", num);
    }else{
        ;
    }
    return data;
}

/***
 * This is for idf
 * **/
map<string, string> ParserXML::getModulePos_IDF(string moduleName)
{
    map<string, string> data;
    TiXmlElement *search, *psearch;
    string tmp="";
    findNode(root,search,"location", "name", moduleName.c_str());
    if(0==strcmp(search->Value(), "location"))
    {
        tmp = getSpecialAttrValue(search, "x");
        data.insert(make_pair("x",tmp));
        tmp = getSpecialAttrValue(search, "y");
        data.insert(make_pair("y",tmp));
        tmp = getSpecialAttrValue(search, "z");
        data.insert(make_pair("z",tmp));
        findNode(search, psearch, "rot");
        if(0==strcmp(psearch->Value(),"rot"))
        {
            tmp = getSpecialAttrValue(psearch, "val");
            data.insert(make_pair("val",tmp));
        }
    }
    return data;
}
std::map<std::string,std::string> ParserXML::getPixels_IDF(const std::string & moduleName)
{
    TiXmlElement *search, *psearch;
    findNode(root,search,"type", "is", "rectangular_detector");
    std::map<std::string,std::string> data;
    std::string tmp;
     if(0==strcmp(search->Value(), "type"))
    {
        tmp = getSpecialAttrValue(search, "xpixels");
        data.insert(make_pair("xpixels",tmp));
        tmp = getSpecialAttrValue(search, "ypixels");
        data.insert(make_pair("ypixels",tmp));
        tmp = getSpecialAttrValue(search, "xstep");
        data.insert(make_pair("xsize",tmp));
        tmp = getSpecialAttrValue(search, "ystep");
        data.insert(make_pair("ysize",tmp));
    }
     findNode(root,search,"location", "name", moduleName.c_str());
    psearch=search->Parent()->ToElement();
    tmp = getSpecialAttrValue(psearch, "idstart");
        data.insert(make_pair("idstart",tmp));
    return data;
}

