#include "StateMachine.hh"

using Status=StateMachine::Status;
using Command=StateMachine::Command;

int main()
{
  StateMachine sm;
  //Define 9 allowed state transit
  //void grantStateTransit(Status from, Status to, Command byCommand);
  sm.grantStateTransit(Status::kUnconfigured, Status::kReady, Command::kConfigure);
  sm.grantStateTransit(Status::kReady, Status::kUnconfigured, Command::kUnconfigure);
  sm.grantStateTransit(Status::kReady, Status::kRunning, Command::kStart);
  sm.grantStateTransit(Status::kRunning, Status::kReady, Command::kStop);
  sm.grantStateTransit(Status::kRunning, Status::kPaused, Command::kPause);
  sm.grantStateTransit(Status::kPaused, Status::kRunning, Command::kResume);
  sm.grantStateTransit(Status::kReady, Status::kError, Command::kAbort);
  sm.grantStateTransit(Status::kRunning, Status::kError, Command::kAbort);
  sm.grantStateTransit(Status::kPaused, Status::kError, Command::kAbort);

  //selfDiagnosis() generates 10k state and command in random combination,
  //and record those in fact can change the state
  sm.selfDiagnosis();
  return 0;
}
