import numpy as np

const_hz2eV = 4.13566769692386e-15  #(source: NIST/CODATA 2018)
const_radpsec2meV =  const_hz2eV/(2*np.pi)/1e-3
const_radpsec2eV = const_radpsec2meV*1e-3
const_radpfs2meV = const_radpsec2meV*1e15

const_c  = 299792458e10 # speed of light in Aa/s
const_dalton2kg =  1.660539040e-27  # amu to kg (source: NIST/CODATA 2018)
const_dalton2eVc2 =  931494095.17  # amu to eV/c^2 (source: NIST/CODATA 2018)
const_avogadro = 6.022140857e23  # mol^-1 (source: NIST/CODATA 2018)
const_boltzmann = 8.6173303e-5   # eV/K
const_neutron_mass = 1.674927471e-24  #gram
const_neutron_mass_evc2 = 1.0454075098625835e-28  #eV/(Aa/s)^2  #fixme: why not calculated from other constants).#<EXCLUDE-IN-NC1BRANCH>
const_neutron_atomic_mass = 1.00866491588  #atomic unit
const_planck = 4.135667662e-15  #[eV*s]
const_hbar = const_planck*0.5/np.pi  #[eV*s]
const_ekin2v = np.sqrt(2.0/const_neutron_mass_evc2)  #multiply with sqrt(ekin) to get velocity in Aa/s#<EXCLUDE-IN-NC1BRANCH>
