#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np
from xlib import *


radpsec2meV =  6.5821e-13
radpfs2meV = radpsec2meV*1e15

fname = 'dump_h5md.h5'
out = 'mdana.h5'
if len(sys.argv)==2:
    fname = sys.argv[1]
if len(sys.argv)==3:
    fname = sys.argv[1]
    out = sys.argv[2]


trj = Trajectory(fname)


tasks = [['hh',1,1],
        ['oo',2,2],
        ['ho',1,2]]

f = h5py.File(out,'w')

timeStep=np.arange(0,trj.nFrame//2, 1,dtype=np.uint32)
Q=np.logspace(-1,2,300)

for atask in tasks:
    grp=f.create_group(atask[0])
    grp['deltaTfs'] = trj.deltaTfs
    grp['t'] = timeStep*trj.deltaTfs
    grp['Q'] = Q

    print('performing task',atask[0] )
    start_time = time.time()
    cvv = trj.cvv(atask[1],atask[2])
    print  ('cvv elapsed ' , time.time() - start_time, 's')
    grp['cvv'] = cvv

    start_time = time.time()
    ftq=trj.intermediate( atask[1],atask[2],  Q, timeStep , 20)
    print  ('intermediate elapsed ' , time.time() - start_time, 's')
    grp['ftq'] = ftq

    # start_time = time.time()
    # rSpacingInAa, tSpacingInfs, rScalefact, gtr = trj.gtr(atask[1],atask[2],15.,1000)
    # print  ('gtr elapsed ' , time.time() - start_time, 's')
    # grp['gtr'] = gtr
    # grp['rSpacingInAa'] = rSpacingInAa
    # grp['tSpacingInfs'] = tSpacingInfs
    # grp['rScalefact'] = rScalefact
    # print  ('time ' , time.time() - start_time, 's')

f.close()
