#include <cstdio>
#include <fstream>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <map>
#include <math.h>

#include "ParserUtils.hh"
#include "PackageHe3.hh"
#include "Hist2DMap.hh"

#include "NumpyHist1D.hh"
#include "NumpyHist2D.hh"

int main(int argc, char *argv[])
{
  //read data
  std::string fname = "/home/xcai/ownCloud/Work/DIM/data/BL02_RUN0005344_He3MODULE_FILE001_20190625110252.dat";
  // std::string fname = "/home/xcai/ownCloud/Work/DIM/data/BL02_RUN0005376_MWPCMODULE01_FILE001_20190625161236.dat";
  std::ifstream source(fname, std::ifstream::ate|std::ios_base::binary);

  // get length of file:
  source.seekg (0, source.end);
  int length = source.tellg();
  source.seekg (0, source.beg);

  // allocate memory:
  const uint8_t * buffer = new uint8_t [length];

  // read data as a block:
  source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
  source.close();
  double filesizeinMB = length/1024./1024.;
  printf("file size is %gMB \n", filesizeinMB);

  unsigned dataloop=10;
  if(argc==2)
    dataloop = atoi(argv[1]);

  //data parser
  auto *he3 = new Parser::PackageHe3(0.);
  unsigned pkgcnt=0; //package counter

  //x tof, y position
  Hist2DMap histmap(2500,0., 4e4, 1200,0.,300);
  printf("Processing raw data %d times\n", dataloop);
  for(unsigned i=0;i<dataloop;i++){ //process the raw data "dataloop times for profiling
    const uint8_t * datastream = buffer;
    while(he3->readNextPackage(datastream, buffer+length, histmap))
    {
      pkgcnt++;
    }
  }
  auto it = histmap.getHistMapBegin();
  auto it_end= histmap.getHistMapEnd();
  unsigned hitcnt = 0.;

  for ( ; it != it_end; ++it)
  {
    unsigned tmp = std::round(it->second->getIntegral());
    hitcnt += tmp;
    printf("histogram %d contains %d hits\n", it->first,tmp );

    // if(it->first==7) //export Histogram
    // {
    //   auto hist7=it->second;
    //   size_t totsize = hist7->getNBinsX()*hist7->getNBinsY();
    //   const double *raw =  hist7->rawContents();
    //   std::ofstream fhist;
    //   fhist.open ("Hist2D.txt");
    //   for(unsigned i=0;i<totsize;i++)
    //   {
    //     fhist << *(raw++) << " ";
    //   }
    //   fhist.close();
    // }
  }

  printf("\nprocessed %gMB raw data \nread %d valid packages, %d events in total\n",  filesizeinMB*dataloop, pkgcnt, hitcnt);
  delete []buffer;
  return 0;
}
