#include <cstdio>
#include <fstream>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>


#include "ParserUtils.hh"
#include "PackageMWPC.hh"
#include "PackageMWPCold.hh"
#include "Hist2DMap.hh"
#include "NumpyHist1D.hh"

int main()
{
  //read data

  std::string fname = "/home/caixx/ownCloud/Work/DIM/data/BL02_RUN0005005_MWPCpackage_FILE001_20190609130207.dat";
  std::ifstream source(fname, std::ifstream::ate|std::ios_base::binary);

  // get length of file:
  source.seekg (0, source.end);
  int length = source.tellg();
  source.seekg (0, source.beg);

  // allocate memory:
  const uint8_t * buffer = new uint8_t [length];

  // read data as a block:
  source.read (reinterpret_cast<char*>(const_cast<uint8_t *>(buffer)),length);
  source.close();
  // printf("file size is %g MB \n", length/1024./1024);

  const uint8_t * const data_end = buffer+length;
  double time_window = 40;
  double charge_threshold = 10;
  Parser::PackageMWPCold mwpc(charge_threshold,time_window);


  const uint8_t * abuf = buffer;

  Hist2DMap histmap(40000 ,0., 4e4, 50*94 , 0.5 ,50*94+0.5);

  auto hist_charge = new NumpyHist1D(5000, -.5, 5000.-0.5);

  unsigned readNPackage=20;
  while (mwpc.readNextPackage(abuf, data_end, histmap, *hist_charge) )
  {
    // if(wdt++==10)
    //   break;
  }
  hist_charge->save("charge.npy");
  

  delete [] buffer;
  return 0;

}
