#!/usr/bin/python

from __future__ import print_function
import h5py
import numpy as np
import matplotlib.pyplot as plt

# (1000, 3333)

f=h5py.File('gtr.h5','r')
gtr=f['gtr'][()]
rSpacingInAa=f['rSpacingInAa'][()]
tSpacingInfs=f['tSpacingInfs'][()]
rScalefact=f['rScalefact'][()]
rSize=f['rSize'][()]
tSizef=f['tSize'][()]
f.close()

rRange = np.arange(rSize) *  rSpacingInAa

idx = [1, 10, 67, 67*2 ,67*2**2, 67*2**3]
for i in idx:
    #plt.plot(spaRange,  gtr[:,i], label = str(tSpacingInfs*i)+'fs')
    plt.plot(rRange, rScalefact * gtr[i,:], label = str(tSpacingInfs*i)+'fs')
    print('Integral ', np.trapz(rScalefact * gtr[i,:], rRange))
plt.xlabel('R, Aa')
plt.legend()
plt.title('Gr mult by 4pi*r*r')

# plt.figure()
#
# idx = [1, 10, 67, 67*2 ,67*2**2, 67*2**3]
# for i in idx:
#     plt.plot(spaRange,  gtr[:,i], label = str(tSpacingInfs*i)+'fs')
# plt.xlabel('R, Aa')
# plt.legend()
# plt.title('Gr raw')

# qrange = np.arange(gtr.shape[0]//2) / rSpacingInAa
#fqt= np.abs(np.fft.rfft(gtr,axis=0)) # should not abs

# plt.figure()
#
#
# plt.semilogx(fqt[1], label = '1')
# plt.semilogx(fqt[fqt.shape[0]//4], label = str(fqt.shape[0]//4))
# plt.semilogx(fqt[fqt.shape[0]//2], label = str(fqt.shape[0]//2))
# plt.legend()
# plt.title('Ft')
#
#
# plt.figure()
# sqw = np.abs(np.fft.rfft(fqt, axis=1))
# plt.imshow(np.log(sqw))
#
# plt.figure()
# plt.plot(sqw[1])
# plt.plot(sqw[10])
# plt.plot(sqw[100])


plt.title('Sw')







plt.show()
