#include "Earthworm.hh"

#include <sys/types.h>
#include <dirent.h>
#include <cstddef>
#include <string>
#include <vector>
#include <iostream>


#include <tinyxml.h>
#include <fstream>
#include "NeXusFile.hpp"
#include <map>
#include "parserXML.h"
#include "parserNXS.h"
#include <math.h>
#include <memory.h>
#include <stdio.h>
#include <typeinfo>
#include <dirent.h>
#include <unistd.h>

using namespace std;

int dim[1]={0};

bool dirExists(const string& dirName_in)
{
    int ftyp = access(dirName_in.c_str(), 0);
    if (0 == ftyp)
        return true;   // this is a directory!  
    else
        return false;
}

void coutVec(vector<string> info)
{
    for(auto it = info.begin(); it!=info.end(); it++)
        cout<<*it<<endl;
}

void coutMap(map<string, string> info)
{
    for(auto it = info.begin(); it!=info.end(); it++)
        cout<<it->first<<"||"<<it->second<<endl;
}

std::vector<string> getFile(string filepath, string midName, string suffixName)
{
    std::vector<string> filename; 
    if(dirExists(filepath))
    {
        DIR *dirp;
        struct dirent *dp;
        dirp=opendir(filepath.c_str());
        while((dp = readdir(dirp))!=NULL)
        {
            string name = dp->d_name;
            int num=name.size();
            if((name.size()>4) && (name.substr(num-3,3)==suffixName))
            { 
		//cout<<name<<endl;  
                if(midName!="")
                {
                    auto iPos = name.find(midName);
                    if(iPos!=name.npos)
                        filename.push_back(filepath+"/"+name);
                }else{
                    filename.push_back(filepath+"/"+name);
                }
            }
        }
    }else{;} 
    return filename;
}

std::vector<string> getOutFile(const vector<string> & fileList,string notIn)
{
    std::vector<string> filename; 
    for(auto it=fileList.begin();it!=fileList.end();it++)
    {
        auto iPos2=(*it).find(notIn);
         if(iPos2==(*it).npos)
	    filename.push_back(*it);
       }
    return filename;
}


//int main(int argc, char *argv[])
int main()
{
   /*
    if(argc<=1)
    {
        printf("Usage:%s runNumber prepath\n", argv[0]);
        return 0;
    }
    string runno=argv[1];
	*/
    string runno = "RUN0006346";
    //get conf file
    string confFile = "/home/durong/git/Earthworm/build/gen_nexus/configure.xml";
    //string confFile = "configure.xml";
    ParserXML confXML(confFile); 
    string filepath = confXML.getPath_CONF("controlPath");
    filepath = filepath + "/"+runno;
    //get control file
    bool dirExists(const string&);
    
    int no = atoi(runno.substr(3).c_str());
    stringstream ss;
    ss<<no;
    string run = ss.str();

    std::vector<string> fileList = getFile(filepath,run,"xml");
    string sumfile="";
    if(fileList.size()==1)
        sumfile = fileList[0];
    fileList.clear();

    //vector<string> moduleName = confXML.getModuleList_CONF("bank");
    vector<string> moduleName;
    moduleName.push_back("module1");

    //get monitor file
    //vector<string> monitorList = confXML.getModuleList_CONF("monitor");
    vector<string> monitorList;
    monitorList.push_back("monitor2");
    monitorList.push_back("monitor3");
    
    //coutVec(monitorList);
    map<string, string> monfileList;
    filepath = confXML.getPath_CONF("monPath");
    //cout<<filepath<<endl;
    for(auto it = monitorList.begin(); it!= monitorList.end(); it++)
    {
        string name =*it;
        name[0]=toupper(name[0]);
        string tmppath = filepath+"/"+name+"/"+runno;
        vector<string> tmpfile = getFile(tmppath,"","bin");
        if(tmpfile.size()==1)
        {
            monfileList.insert(make_pair(*it,tmpfile[0]));
        }
    }
    monitorList.clear();
    for(auto it = monfileList.begin(); it!=monfileList.end(); it++)
        monitorList.push_back(it->first);
    
    //test
    //coutMap(monfileList);
    // parse summary
    ParserXML sumXML(sumfile);
    //string mode = sumXML.getBankMode_SUM();
    string inst = confXML.getInstName_CONF();
    //cout<<inst<<endl;
    //cout<<mode<<"||"<<inst<<endl;
    
    //get xml file
    string idffile="";
    string tmpfile = confXML.getPath_CONF("idfPath");
    if(inst=="MR")
    {
        string mode = sumXML.getBankMode_SUM();
        idffile = tmpfile+"/bank_"+mode+".xml";
    }else{
        idffile = tmpfile+"/bank.xml";
    }

    //get daq file
    filepath = confXML.getPath_CONF("daqPath");
    filepath = filepath+"/"+runno;
    std::vector<string> tmp = getFile(filepath,"MODULE","dat");
    std::vector<string> daqList=getOutFile(tmp,"T0");
    //coutVec(daqList);
    //cout<<idffile<<endl;
    //string mdffile = tmpfile+"/monitor.xml";

    ParserXML idfXML(idffile);
    //create nexus file 
    string prepath = confXML.getPath_CONF("prePath");
    string nxsfilename=prepath+"/"+runno+"/detector.nxs";

    //string nxsfilename = "/home/dur/BL18/RUN0004077/detector.nxs";
    ParserNXS m_nxs(nxsfilename);
    m_nxs.createNXS();
    //m_nxs.setPublic(sumXML,idffile, mdffile);
    m_nxs.setPublic(sumXML,idffile);
    //cout<<nxsfilename<<endl; 
    
    m_nxs.setInstrument(sumXML);
    
    
    m_nxs.setBank(confXML,sumXML, idfXML, daqList);
    
    m_nxs.setMonitor(confXML,sumXML, idfXML, monfileList);
    m_nxs.setHistData(monitorList);
    m_nxs.setHistData(moduleName);
    m_nxs.setEventData(moduleName);

    
    cout<<"finish save nexus"<<endl;
    string path = prepath+"/"+runno+"/complete.dat";
    std::ofstream markfile;
    markfile.open(path.c_str());
    markfile<<"completed"<<endl;
    markfile.close();

    return 0;
}

