#!/usr/bin/python

from __future__ import print_function
import vacf
import time
import sys
import h5py
import numpy as np

# limitations:
# 1. step time must be a constant
class Trajectory:
    def __init__(self, fileName, atomsPerMoni):
      f=h5py.File(fileName,'r')
      #species axes: [atomID,timeStep]
      self.species=f['particles']['all']['species']['value'][0,:][()]
      self.atomType = np.unique(self.species)
      # // if(!qSpacing)
      # //    qSpacing = 2*M_PI/ (*std::max_element(box, box+boxSize)) *2;

      t = f['particles']['all']['species']['time']
      self.deltaTfs = t[1]-t[0]

      #pos axes: [atomID,timeStep, xyz]
      self.trj = self.swapaxes(f['particles']['all']['position']['value'][()])

      #box axes: [timeStep, xyz]
      self.box=f['particles']['all']['box']['edges']['value'][()]
      f.close()

      self.nTimeStep= self.trj.shape[1]
      self.nAtom = self.trj.shape[0]

    def getAtomType(self):
        return self.atomType

    def getDeltaT(self):
        return self.deltaTfs

    def swapaxes(self, data):
        data=np.swapaxes(data,0,1)
        return np.ascontiguousarray(data)

    def incoherentIntermediate(self, atomType, QVec, timeVec):
        if atomType not in self.atomType:
             raise RuntimeError('atom type ', atomType, ' is not found in the atom type list')

        FsTQ = np.zeros([timeVec.size, QVec.size ], dtype = np.float64)
        atomID = np.arange(0, 648, 3, dtype=np.uint32)
        atomicPair = np.ascontiguousarray(np.tile(atomID,(2,1)).swapaxes(0,1))
        atomicPair[:,1]+=0
        atomicPair[:,0]+=1

        vacf.intermediate(self.trj, self.trj.size,
            atomicPair, atomicPair.size,
            self.box, self.box.size,
            QVec, timeVec,
            self.nAtom, self.nTimeStep, FsTQ, FsTQ.size);

        return FsTQ
