#include "NumpyHist2D.hh"
#include <cmath>
#include <vector>
#include <iostream>

NumpyHist2D::NumpyHist2D(unsigned xnbins, double xmin, double xmax,
                         unsigned ynbins, double ymin, double ymax)
:NumpyHistBase(xnbins*ynbins), m_xbinfactor(xnbins/(xmax-xmin)),
m_ybinfactor(ynbins/(ymax-ymin))
{
  m_xmin=xmin, m_xmax=xmax, m_xnbins=xnbins;
  m_ymin=ymin, m_ymax=ymax, m_ynbins=ynbins;
  m_nbins = m_xnbins * m_ynbins;

  // std::invalid_argument("data can not be shaped by the given shape vector");

}

NumpyHist2D::~NumpyHist2D()
{
}

void NumpyHist2D::serialise(std::string &serialised) const
{
  serialise_numpy(std::vector<uint64_t>{m_xnbins, m_ynbins}, serialised);
}

//Normal filling:
void NumpyHist2D::fill(double xval, double yval)
{
  std::lock_guard<std::mutex> guard(m_hist_mutex);

  m_sumW++;

  if(xval<m_xmin ||  yval<m_ymin) {
    m_underflow++;
    return;
  }
  else if(xval>m_xmax || yval>m_ymax) {
    m_overflow++;
    return;
  }
  unsigned ix = floor((xval-m_xmin)*m_xbinfactor);
  unsigned iy = floor((yval-m_ymin)*m_ybinfactor);
  //std::cout << ix << " " << iy << '\n';
  m_data[ix*m_ynbins + iy]+=1;
}

void NumpyHist2D::fill(double xval, double yval, double w)
{
  std::lock_guard<std::mutex> guard(m_hist_mutex);
  m_sumW += w;

  if(xval<m_xmin ||  yval<m_ymin) {
    m_underflow+=w;
    return;
  }
  else if(xval>m_xmax || yval>m_ymax) {
    m_overflow+=w;
    return;
  }
  unsigned ix = floor((xval-m_xmin)*m_xbinfactor);
  unsigned iy = floor((yval-m_ymin)*m_ybinfactor);
  m_data[iy*m_xnbins + ix]+=w;
}

void NumpyHist2D::getXSum(std::vector<double> &x)
{
  x.clear();
  x.reserve(m_xnbins);
  for(unsigned ix=0;ix<m_xnbins;ix++)
  {
    double sum(0.);
    for(unsigned iy=0;iy<m_ynbins;iy++)
      sum += m_data[iy*m_xnbins + ix];
    x.push_back(sum);
  }
}

void NumpyHist2D::getYSum(std::vector<double> &y)
{
  y.clear();
  y.reserve(m_ynbins);
  for(unsigned iy=0;iy<m_ynbins;iy++)
  {
    double sum(0.);
    for(unsigned ix=0;ix<m_ynbins;ix++)
      sum += m_data[iy*m_xnbins + ix];
    y.push_back(sum);
  }
}
