#ifndef RedisIO_hh
#define RedisIO_hh

#include <string>
#include <cpp_redis/cpp_redis>

class RedisIO {
public:
  RedisIO(const std::string& ip_addr, unsigned port, const std::string& usrname, const std::string& password);
  virtual ~RedisIO();

  //Redis connection is slow! use with care
  //latency of a connection is of the order of ms
  void writeString(const std::string& path, const std::string& str);
  std::string readString(const std::string& path, bool checktype=false);
  // int readInt(const std::string& path);
  void writeInt(const std::string& path, int i);

private:
  void connect();
  cpp_redis::client m_client;
  const std::string m_ip_addr, m_usrname, m_password;
  const unsigned m_port;
};

#endif
