#include "Earthworm.hh"
#include <iostream>
#include "spdlog/sinks/basic_file_sink.h" // support for basic file logging
#include "spdlog/sinks/rotating_file_sink.h" // support for rotating file logging
#include "spdlog/sinks/daily_file_sink.h"

Earthworm* Earthworm::m_instance = 0;
std::string Earthworm::m_reidsIP = "10.1.31.120";
Earthworm::Earthworm()
{
}

Earthworm::~Earthworm()
{
  spdlog::shutdown();
}

const Earthworm * Earthworm::instance()
{
  static Earthworm instance;
  return &instance;
}

void Earthworm::enableRatingLogger(const std::string& fname) const
{
  try
  {
      // create a file rotating logger with 1mb size max and 100 rotated files
      auto file_logger = spdlog::rotating_logger_mt("file_logger", fname, 1024 * 1024 , 100);
      spdlog::set_default_logger(file_logger);
  }
  catch (const spdlog::spdlog_ex& ex)
  {
      std::cout << "Log initialization failed: " << ex.what() << std::endl;
  }
}

void Earthworm::enableDailyLog(const std::string& fname) const
{
  try
  {
    // Create a daily logger - a new file is created every day on 2:30am.
    auto daily_logger = spdlog::daily_logger_mt("daily_logger", fname, 2, 30);
  }
  catch (const spdlog::spdlog_ex& ex)
  {
      std::cout << "Log initialization failed: " << ex.what() << std::endl;
  }
}


const std::string& Earthworm::getRedisIP() const
{
  return m_reidsIP;
}

void Earthworm::setRedisIP(const std::string& str)
{
  m_reidsIP=str;
}
