#include "PackageHe3PosCorr.hh"
#include "Earthworm.hh"

Parser::PackageHe3PosCorr::PackageHe3PosCorr(double threshold_lower, double threshold_upper, double hvlength, double tofscale, unsigned num_module)
:PackageHe3(threshold_lower, hvlength, tofscale), m_charge_threshold_upper(threshold_upper), m_module(num_module)
{

  std::vector<float> kF {652.021, 654.336, 646.404, 651.417, 644.592, 648.433, 652.676, 652.243, 653.24, 648.828, 652.028, 649.554, 640.401, 642.552, 646.052, 641.191, 638.309, 638.856, 641.175, 641.514, 640.516, 642.203, 638.39, 641.419, 638.458, 644.108, 644.522, 642.148, 641.015, 646.078, 642.319, 639.046, 638.863, 644.927, 639.652, 637.259, 646.996, 639.706, 643.4, 648.561, 646.717, 646.976, 649.141, 642.096, 646.273, 646.459, 642.153, 639.53, 643.897, 647.232, 647.217, 644.928, 642.977, 647.28, 644.519, 650.31, 646.345, 643.279, 641.464, 644.055, 643.541, 642.468, 639.266, 646.766, 642.657, 643.994, 644.495, 642.422, 644.539, 641.171, 640.883, 641.668, 649.729, 645.198, 653.341, 643.322, 648.052, 643.285, 645.499, 645.809, 650.5, 647.664, 643.919, 640.72, 649.052, 647.288, 650.026, 645.833, 651.06, 646.974, 647.717, 644.537, 648.395, 647.669, 646.16, 641.899, 637.929, 643.214, 639.913, 639.665, 641.954, 645.329, 642.226, 640.059, 642.538, 643.824, 654.515, 651.553, 651.945, 644.148, 646.242, 648.156, 646.396, 645.952, 644.829, 647.098, 646.007, 647.186, 646.063, 643.168};

  std::vector<float>  bF {509.498, 524.227, 504.65, 514.955, 503.662, 495.664, 508.137, 509.367, 486.148, 513.613, 525.655, 513.39, 538.417, 482.455, 511.868, 516.02, 499.218, 510.803, 487.762, 495.786, 502.396, 497.732, 506.726, 481.936, 524.041, 503.362, 482.808, 491.595, 516.966, 514.346, 501.289, 487.656, 493.118, 486.07, 493.49, 482.412, 531.028, 517.884, 530.924, 541.751, 516.465, 513.633, 547.366, 509.207, 529.584, 548.797, 485.059, 517.257, 470.795, 504.579, 462.171, 487.16, 491.95, 476.097, 475.509, 463.019, 449.527, 480.352, 491.776, 471.874, 490.637, 483.131, 512.703, 499.938, 502.398, 486.196, 506.583, 494.829, 494.442, 508.431, 505.361, 525.168, 474.713, 496.15, 454.889, 507.377, 491.325, 499.436, 470.139, 472.651, 449.392, 459.263, 497.304, 483.981, 512.078, 498.4, 517.587, 509.268, 505.854, 502.457, 503.469, 513.076, 476.583, 506.454, 488.657, 514.141, 500.764, 520.459, 494.249, 492.623, 522.478, 501.383, 493.044, 507.371, 504.02, 499.569, 489.668, 538.796, 524.269, 517.752, 522.742, 532.115, 516.139, 490.966, 526.688, 506.279, 519.686, 560.481, 537.823, 540.212};

  unsigned i=0;
  for ( int n = 12*(m_module-1); n<12*(m_module-1)+12; n++ , i++)
  {
      m_kfactor.push_back(kF[n]);
      m_bfactor.push_back(bF[n]);
  }
}

Parser::PackageHe3PosCorr::~PackageHe3PosCorr(){}

bool Parser::PackageHe3PosCorr::readNextPackage(const uint8_t*& pt, const uint8_t * const stream_end, std::vector<HitInfo>& hitinfo) const
{
  const uint8_t *package_end;
  uint64_t offset=0;

  if(!findNextPackage(pt, stream_end, package_end, offset))
    return false;

  Parser::ParserHe3::Header *header = new Parser::ParserHe3::Header();
  readHeader(pt, header);

  Parser::ParserHe3::Info info;
  readInfo(pt, info);
  double baseline_factor = 1./info.sample_num_bl;



  std::vector<HitInfo> temp;
  std::swap(temp,hitinfo);
  hitinfo.reserve(info.hit_cnt);
  if(info.hit_cnt)
  {
    Parser::ParserHe3::Hit hit ;
    //the next while loop breaks when pt==package_end-8
    while (pt != package_end-8) {
      //error_assert(pt<package_end-8); //shouldn't really happen
      readHit(pt,hit);
      double upper = hit.upper_charge - hit.upper_baseline*baseline_factor;
      double lower = hit.lower_charge - hit.lower_baseline*baseline_factor;
      double tot = upper + lower;
      if(!tot || tot<=m_charge_threshold || tot>=m_charge_threshold_upper)
        continue;
      else if(header->module>10)
      {
        EW_LOG_WARN("Module id is greater than 10");
      }
      else
      {
          double x    = m_kfactor[hit.tube_id]*(upper-lower)/(tot) + m_bfactor[hit.tube_id];
          hitinfo.push_back(HitInfo( x , hit.tube_id,
          hit.time*m_tof2us, tot, info.t0_count, header->module));
          // printf("pos %g, time stamp %d , tube_id %d\n", 150.*( 1 + (upper-lower)/tot ) ,hit.time*m_tof2us, hit.tube_id ); abort();
      }
    }
  }
  pt = package_end;

  delete header;

  //printf("left %ld, package_end %p, stream_end %p\n", stream_end-package_end, package_end, stream_end);
  return package_end==stream_end?false:true;

}
