#!/usr/bin/python

from __future__ import print_function
import h5py
import numpy as np
import matplotlib.pyplot as plt

# (1000, 3333)

f=h5py.File('gtr.h5','r')
gtr=f['gtr'][()]
rSpacingInAa=f['rSpacingInAa'][()]
tSpacingInfs=f['tSpacingInfs'][()]
rScalefact=f['rScalefact'][()]
rSize=f['rSize'][()]
tSize=f['tSize'][()]
f.close()

rRange = np.arange(rSize) *  rSpacingInAa
tRange = np.arange(tSize) *  tSpacingInfs

print('rSize', rSize)
print('tSize', tSize)

idx = [1, 10, 67, 67*2 ,67*2**2, 67*2**3]
for i in idx:
    #plt.plot(spaRange,  gtr[:,i], label = str(tSpacingInfs*i)+'fs')
    plt.plot(rRange, rScalefact * gtr[i,:], label = str(tRange[i])+'fs')
    print('Integral ', np.trapz(rScalefact * gtr[i,:], rRange))
plt.xlabel('R, Aa')
plt.legend()
plt.title('Gr mult by 4pi*r*r')


############################
plt.figure()

def FFT (data, spacing, axis=-1):
    Fs = 1./spacing
    L = data.shape[axis]
    FFT_y = np.fft.ifft(data,axis=axis, norm = "ortho")
    Fre = np.arange(L//2)*Fs/L
    FFT_y = FFT_y[:,range(L//2)]
    return Fre, FFT_y

ftq = np.fft.fft(gtr,axis=1, norm = "ortho")
qRange = np.fft.fftfreq(rSize) /rSpacingInAa

#print('qSize', qSize)

print("ftq shape", ftq.shape)
idx = [1, 10, 67, 67*2 ,67*2**2]
for i in idx:
    plt.semilogx(tRange, abs(ftq[:,i]), label = str(qRange[i])+'Aa^-1')
plt.legend()
plt.title('Ft')

#
# plt.figure()
# sqw = np.abs(np.fft.rfft(fqt, axis=1))
# plt.imshow(np.log(sqw))
#
# plt.figure()
# plt.plot(sqw[1])
# plt.plot(sqw[10])
# plt.plot(sqw[100])


plt.title('Sw')







plt.show()
