find_path ( CPP_REDIS_INCLUDE_DIR cpp_redis/cpp_redis
        PATH_SUFFIXES include HINTS "/opt/shared/library/cpp_redis")

if (CPP_REDIS_INCLUDE_DIR)
  message (STATUS "Found cpp_redis header at ${CPP_REDIS_INCLUDE_DIR}")
else()
  message (STATUS "cpp_redis header NOT FOUND")
endif()

list(APPEND HINTS_LS "/opt/shared/library/cpp_redis/lib" )
find_library (CPP_REDIS_ALONE_LIBRARIES NAMES cpp_redis HINTS ${HINTS_LS} )
find_library (CPP_REDIS_ALONE_LIBRARIES_DEBUG NAMES cpp_redis HINTS ${HINTS_LS} )

find_library (TACOPIE_LIBRARIES NAMES tacopie  HINTS ${HINTS_LS} )
find_library (TACOPIE_LIBRARIES_DEBUG NAMES tacopie  HINTS ${HINTS_LS} )

if ( CPP_REDIS_ALONE_LIBRARIES_DEBUG AND TACOPIE_LIBRARIES_DEBUG )
  set ( CPP_REDIS_LIBRARIES optimized ${CPP_REDIS_ALONE_LIBRARIES}
                        optimized ${TACOPIE_LIBRARIES}
                        debug ${CPP_REDIS_ALONE_LIBRARIES_DEBUG}
                        debug ${TACOPIE_LIBRARIES_DEBUG} )
else()
  set ( CPP_REDIS_LIBRARIES ${CPP_REDIS_ALONE_LIBRARIES} ${TACOPIE_LIBRARIES} )
endif()


if (CPP_REDIS_LIBRARIES)
  message (STATUS "Found libcpp_redis ${CPP_REDIS_LIBRARIES}")
endif()

unset(HINTS_LS)
unset(TACOPIE_LIBRARIES)
unset(TACOPIE_LIBRARIES_DEBUG)
unset(CPP_REDIS_ALONE_LIBRARIES)
unset(CPP_REDIS_ALONE_LIBRARIES_DEBUG)
