#ifndef Histogram_Hist2DMap_hh
#define Histogram_Hist2DMap_hh

#include <map>
#include <vector>
#include <mutex>
#include <iostream>
#include "NumpyHist2D.hh"

// This class reads information from a full package.
class Hist2DMap {
public:
  enum DetectorType
  {
    kUnknown,
    kHe3, //helium 3
    kMWPC    //multi-wire proportional counter
  };
public:
  Hist2DMap(unsigned nbinsx, double xmin, double xmax,
         unsigned nbinsy, double ymin, double ymax, DetectorType dt=kUnknown);
  virtual ~Hist2DMap();

  inline void fill(unsigned key, double x, double y);
  void reset();
  DetectorType getDetType(){ return m_dettype; }
  std::map<unsigned, NumpyHist2D* >::const_iterator getHistMapBegin() const;
  std::map<unsigned, NumpyHist2D* >::const_iterator getHistMapEnd() const;

  double getIntegral();
  void merge(std::string &data);
  void makeNumpyRaw(std::string &data, const std::vector<unsigned> &order);
  //untested code
  void makeNumpyXSum(std::string &data, const std::vector<unsigned> &order);
  void makeNumpyYSum(std::string &data, const std::vector<unsigned> &order);

private:
  std::mutex m_histmap_mutex;
  std::map<unsigned, NumpyHist2D* > m_histmap;
  const unsigned m_xbin;
  const double m_xl, m_xu;
  const unsigned m_ybin;
  const double m_yl, m_yu;
  const DetectorType m_dettype;
};



inline void Hist2DMap::fill(unsigned key, double x, double y)
{
  // Lock The Data structure
  std::lock_guard<std::mutex> guard(m_histmap_mutex);

  auto it_hist = m_histmap.find(key);
  NumpyHist2D *histpt;
  //create a new histogram for a new key
  if(it_hist==m_histmap.end()) {
    histpt = new NumpyHist2D(m_xbin, m_xl, m_xu, m_ybin, m_yl, m_yu);
    m_histmap[key] = histpt;
  }
  else
    histpt = it_hist->second;

  histpt->fill(x,y);
}
#endif
