#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include <nlohmann/json.hpp>
#include <stdexcept>

#include "DAQInterface.hh"
#include "Hist2DMap.hh"
#include "RedisIO.hh"
#include "Earthworm.hh"
#include "RedisNumpy.hh"
#include "StateMachine.hh"

#include "Action_Monitor.hh"

int main(int argc, char *argv[])
{
	// if(argc!=2)
	//   throw std::runtime_error("Module name must be provided\n");

	std::cout << "Starting client..." << std::endl;


	//redis should retrive all parameters

	RedisIO *redis = new RedisIO("10.1.33.141", 9001, "neonmaster", "sanlie;123");
	StateMachine *sMachine = new StateMachine();
	//std::string monitorName = "gppd:monitor2";
	std::string monitorName = "mr:monitor1";
	Earthworm::instance()->enableRatingLogger(monitorName);

	std::string histDestination = "/GPPD/workspace/monitor2/value";
	std::string hbPath = "/GPPD/heartbeat/earthworm/monitor2";
	std::string contralPath = "/GPPD/control/command/earthwormx";

  Action_Monitor *action = new Action_Monitor(redis, sMachine, monitorName,
	              histDestination,hbPath,contralPath);

	sMachine->grantStateTransit(State::kUnconfigured, State::kReady, Command::kConfigure, std::bind( &Action_Monitor::configure, action), "configure");
  sMachine->grantStateTransit(State::kReady, State::kUnconfigured, Command::kUnconfigure, std::bind( &Action_Monitor::unconfigure, action), "unconfigure");
	sMachine->grantStateTransit(State::kReady, State::kUnconfigured, Command::kAbort, std::bind( &Action_Monitor::unconfigure, action), "unconfigure");

  sMachine->grantStateTransit(State::kReady, State::kRunning, Command::kStart, std::bind( &Action_Monitor::start, action), "start");
  sMachine->grantStateTransit(State::kRunning, State::kReady, Command::kStop, std::bind( &Action_Monitor::pauseStop, action), "pauseStop");
  sMachine->grantStateTransit(State::kRunning, State::kPaused, Command::kPause, std::bind( &Action_Monitor::pauseStop, action), "pauseStop");
  sMachine->grantStateTransit(State::kPaused, State::kRunning, Command::kResume, std::bind( &Action_Monitor::resume, action), "resume");
  sMachine->grantStateTransit(State::kRunning, State::kUnconfigured, Command::kAbort, std::bind( &Action_Monitor::unconfigure, action), "unconfigure");
  sMachine->grantStateTransit(State::kPaused, State::kUnconfigured, Command::kAbort, std::bind( &Action_Monitor::unconfigure, action), "unconfigure");
	sMachine->grantStateTransit(State::kRunning, State::kRunning, Command::kStart, std::bind( &Action_Monitor::keepRunning, action), "keepRunning");
	sMachine->grantGlobalTransitTo(State::kError, Command::kKill, std::bind( &Action_Monitor::kill, action), "kill");

  sMachine->selfDiagnosis();

  unsigned loop(0);
	bool asString (false);
	while(sMachine->getState()!=State::kError)
	{
		std::this_thread::sleep_for(std::chrono::milliseconds(100));

		action->sendHeartbeat(asString);
		loop++;
		if(!(loop%50))
		   action->update();

  }

  delete redis;
	delete sMachine;
	delete action;

	EW_LOG_INFO("monitor {} is exiting...", monitorName);
  return 0;
}
