
find_path ( PVDATA_INCLUDE_DIR NAMES pv/pvData.h
        HINTS "/opt/shared/library/epics-4.7.0/pvDataCPP/include" "/opt/shared/library/epics-4.5.0/pvDataCPP/include")

find_path (PVACCESS_INCLUDE_DIR NAMES pv/pvAccess.h
        HINTS "/opt/shared/library/epics-4.7.0/pvAccessCPP/include" "/opt/shared/library/epics-4.5.0/pvAccessCPP/include")

find_path ( EPICS3_INCLUDE_DIR epicsThread.h
        HINTS "/opt/shared/library/epics/base-3.15.5/include" "/opt/shared/library/epics-3.15.5/include")


find_path ( EPICS3OS_INCLUDE_DIR osdEvent.h
        HINTS "/opt/shared/library/epics/base-3.15.5/include/os/Linux" "/opt/shared/library/epics-3.15.5/include/os/Linux")

find_path ( EPICS3GCC_INCLUDE_DIR compilerSpecific.h
        HINTS "/opt/shared/library/epics/base-3.15.5/include/compiler/gcc" "/opt/shared/library/epics-3.15.5/include/compiler/gcc")


if (PVACCESS_INCLUDE_DIR)
  message (STATUS "Found PVACCESS_INCLUDE_DIR at ${PVACCESS_INCLUDE_DIR}")
else()
  message (STATUS "PVACCESS_INCLUDE_DIR NOT FOUND")
endif()

if (PVDATA_INCLUDE_DIR)
  message (STATUS "Found PVDATA_INCLUDE_DIR at ${PVDATA_INCLUDE_DIR}")
else()
  message (STATUS "PVDATA_INCLUDE_DIR NOT FOUND")
endif()

if (EPICS3_INCLUDE_DIR)
  message (STATUS "Found EPICS3_INCLUDE_DIR at ${EPICS3_INCLUDE_DIR}")
else()
  message (STATUS "EPICS3_INCLUDE_DIR NOT FOUND")
endif()

if (EPICS3OS_INCLUDE_DIR)
  message (STATUS "Found EPICS3OS_INCLUDE_DIR at ${EPICS3OS_INCLUDE_DIR}")
else()
  message (STATUS "EPICS3OS_INCLUDE_DIR NOT FOUND")
endif()

if (EPICS3GCC_INCLUDE_DIR)
  message (STATUS "Found EPICS3GCC_INCLUDE_DIR at ${EPICS3GCC_INCLUDE_DIR}")
else()
  message (STATUS "EPICS3GCC_INCLUDE_DIR NOT FOUND")
endif()


if(PVACCESS_INCLUDE_DIR AND PVACCESS_INCLUDE_DIR AND EPICS3_INCLUDE_DIR AND EPICS3OS_INCLUDE_DIR AND EPICS3GCC_INCLUDE_DIR)
  MARK_AS_ADVANCED(PVDATA_INCLUDE_DIR)
  MARK_AS_ADVANCED(PVACCESS_INCLUDE_DIR)
  set(EPICS4_INCLUDE_DIR ${PVACCESS_INCLUDE_DIR} ${PVDATA_INCLUDE_DIR} ${EPICS3_INCLUDE_DIR} ${EPICS3OS_INCLUDE_DIR} ${EPICS3GCC_INCLUDE_DIR})
endif()

if (EPICS4_INCLUDE_DIR)
  message (STATUS "Found Epics4 header at ${EPICS4_INCLUDE_DIR}")
else()
  message (STATUS "Epics4 header NOT FOUND")
endif()

list(APPEND HINTS_LS "/opt/shared/library/epics-4.7.0/pvDataCPP/lib/linux-x86_64" "/opt/shared/library/epics-4.7.0/pvAccessCPP/lib/linux-x86_64" "/opt/shared/library/epics-4.5.0/pvDataCPP/lib/linux-x86_64" "/opt/shared/library/epics-4.5.0/pvAccessCPP/lib/linux-x86_64")
find_library (PVDATA_LIBRARIES NAMES pvData  HINTS ${HINTS_LS} )
find_library (PVACCESS_LIBRARIES NAMES pvAccess  HINTS ${HINTS_LS} )

if ( PVDATA_LIBRARIES AND PVACCESS_LIBRARIES )
  set ( EPICS4_LIBRARIES ${PVDATA_LIBRARIES}
                        ${PVACCESS_LIBRARIES} )
endif()


if (EPICS4_LIBRARIES)
  message (STATUS "Found library ${EPICS4_LIBRARIES}")
else()
  message (STATUS "Can't find Epics libaraies")
endif()

unset(HINTS_LS)
