#include "DaqTaskGPPD.hh"
#include <thread>
#include <chrono>
#include <iostream>
#include "PackageHe3.hh"
#include "PackageMWPC.hh"
#include "Earthworm.hh"
#include "PMTParser.hh"

DaqTaskGPPD::DaqTaskGPPD(uint8_t* begin, uint8_t* end, std::shared_ptr<NumpyHist2D>& m_hist2d)
:DaqTask(begin,end), m_hist2d(m_hist2d)
{
}

DaqTaskGPPD::~DaqTaskGPPD()
{
}

uint64_t DaqTaskGPPD::run()
{
    std::lock_guard<std::mutex> guard(m_run_mutex);

    const uint8_t * abuf = m_data.data();
    int event_cnt=0;
    std::vector<Parser::HitInfo> hitinfo;

    if(m_hist2d.get())
    {
      double digit2us = 1./40;
      Parser::PMTParser pmt;

      while(pmt.extractNextPackage(abuf, m_data.data()+m_data.size(), hitinfo))
      {
        event_cnt+=hitinfo.size();
        for(auto v: hitinfo)
        {
          // unsigned pid = pmt.getPixelID((int)v.pos,  (int)v.posy, false);
          // m_hist2d->fill( (int)(v.t/40), pid);

           unsigned pid =  uint64_t(v.posy)/8*(111/2+1)+uint64_t(v.pos)/8;
           m_hist2d->fill( (int)(v.t/40), pid );
        }
      }
    }
    else
      return 0;
    uint64_t shiftedEvt = event_cnt*4294967296;  //shifting 32 bits to the higher order
    return (uint64_t)m_data.size() +  shiftedEvt;
}
