
#include <dic.hxx>
#include <iostream>
#include <vector>
#include <string>
#include <fstream>
#include <memory>
#include <chrono>
#include <future>
#include "Action_Monitor.hh"
#include "Earthworm.hh"


Action_Monitor::Action_Monitor(RedisIO *redis, StateMachine *sMachine,
  const std::string & monitor_name, const std::string & redis_path)
: Action(redis), m_monitor( new  monitor(monitor_name, 40000/16,-0.5,40000-0.5., 32*32 , -0.5, 32*32-0.5))
	m_sMachine(sMachine), m_active_daq(nullptr), m_module(monitor_name), m_redisPath(redis_path)
{
  m_monitor->clear();
  m_monitor->stop();
  m_accumulator = std::thread(&EwMonitor::houseKeeping, m_monitor);
  m_accumulator.detach();

}

Action_Monitor::~Action_Monitor()
{
	m_monitor->stop();
  delete m_monitor;
}

bool Action_Monitor::configure()
{
  //send empty hist
  m_monitor->clear();
  m_monitor->stop();

  std::string redisDataStr;
  m_monitor->getHist.serialise(redisDataStr);
  m_redis->writeString(m_redisPath, redisDataStr);

	EW_LOG_INFO("configure:: Configuration completed. ");
	return true;
}

//Stop running and clear any runtime determined parameter
bool Action_Monitor::unconfigure()
{
	m_monitor->stop();
	EW_LOG_INFO("unconfigure:: Earthworm unconfigured.");
	return true;
}

//Start accumulate data, RESET AGAIN HERE
bool Action_Monitor::start()
{
  m_monitor->clear();
  std::string redisDataStr;
  m_monitor->getHist.serialise(redisDataStr);
  m_redis->writeString(m_redisPath, redisDataStr);

	m_monitor->start();

	m_startTime = std::chrono::steady_clock::now();
  EW_LOG_INFO("start:: Run started.");

	return true;
}

//Paused fill histogram, still receive but unprocess dim datastream
bool Action_Monitor::pauseStop()
{
	m_monitor->stop();
	EW_LOG_INFO("pauseStop:: kPause or kStop.");
	return true;
}

bool Action_Monitor::abort()
{
	m_monitor->stop();
	EW_LOG_INFO("abort:: aborting");
	return true;
}

//Restart running
bool Action_Monitor::resume()
{
	m_monitor->start();
	EW_LOG_INFO("resume:: kResume.");
	return true;
}

bool Action_Monitor::kill()
{
	return true;
}


void Action_Monitor::sendHeartbeat(bool stateAsStr)
{
  nlohmann::json j;
  j["pid"] =std::to_string(m_proID);
	if(stateAsStr)
	  j["status"] = m_sMachine->printState();
  else
		j["status"] = std::to_string(m_sMachine->getState());

  std::time_t t = std::time(nullptr);
  char mbstr[100];
  if (std::strftime(mbstr, sizeof(mbstr), "%Y-%m-%dT%H:%M:%S.%03d+08:00", std::localtime(&t))) {
  }

  j["timestamp"] = std::string (mbstr);
  std::string hb= j.dump();
	// std::cout << "Heartbeart " << hb  << '\n';

  m_redis->writeString( "/GPPD/heartbeat/earthworm/monitor2",hb);
}

bool Action_Monitor::update()
{
	std::string str = m_redis->readString("/GPPD/control/command/earthworm");
  return m_sMachine->transit(atoi(str.c_str()));
}

bool Action_Monitor::keepRunning()
{
  std::string redisDataStr;
  m_monitor->getHist.serialise(redisDataStr);
  m_redis->writeString(m_redisPath, redisDataStr);

	return true;
}
