#ifndef Action_Monitor_hh
#define Action_Monitor_hh

#include <thread>
#include "NumpyHist2D.hh"
#include "RedisIO.hh"
#include "RedisNumpy.hh"
#include "StateMachine.hh"
#include "Action.hh"
class EwMonitor;
class Action_Monitor : public Action {
public:
	Action_Monitor(RedisIO *redis, StateMachine *sMachine, const std::string & monitor_name, const std::string & redis_path);
	virtual ~Action_Monitor();

	int getServerPid() {return m_active_daq->getServerPid(); }

	bool configure();
	//Stop running and clear any runtime determined parameter
  bool unconfigure();
  //Start accumulate data, RESET AGAIN HERE
	bool start();
	//Paused fill histogram, still receive but unprocess dim datastream
	bool pauseStop();
  //Back to unconfigure state
	bool abort();
  //Restart running;
	bool resume();
  //received kill command. Set m_kill so breakLoop can break external loops
	bool kill();
	bool keepRunning();

  void sendHeartbeat(bool stateAsStr=false);
  bool update();

//private:

	StateMachine *m_sMachine;
	EwMonitor *m_monitor;
	std::chrono::time_point<std::chrono::steady_clock>  m_startTime;
	const std::string m_module, m_redisPath;
	std::thread m_accumulator;
};


#endif
